<?php
namespace Mainto\Bridge\Invokes\UserMember\CpMember\Cron;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method cpMemberScoreIncrByParams(array $params)
 * @method cpMemberScoreInflationByParams(array $params)
 * @method cpMemberExpiredByParams(array $params)
 * @method recoverCpMemberByParams(array $params)
 */
class CpMemberCron {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 每天0点到6点每20s跑1次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cpMemberScoreIncr () {
        return self::getClass()->cpMemberScoreIncr();
    }

    /**
     * 每天0点到6点每20s跑1次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cpMemberScoreInflation () {
        return self::getClass()->cpMemberScoreInflation();
    }

    /**
     * 每天0点到6点每20s跑1次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function cpMemberExpired () {
        return self::getClass()->cpMemberExpired();
    }

    /**
     * 每天0点到6点每20s跑1次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function recoverCpMember () {
        return self::getClass()->recoverCpMember();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'CpMember\Cron\CpMemberCron');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'CpMember\Cron\CpMemberCron');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}