<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderFlowByParams(array $params)
 * @method batchCreateOrderFlowByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method unbindOrderByParams(array $params)
 * @method calcLevelByParams(array $params)
 * @method getUserUpgradeTargetByParams(array $params)
 * @method getMembersByParams(array $params)
 * @method getMemberInfoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method getMemberRuleByParams(array $params)
 * @method useExpeditedTimesByParams(array $params)
 * @method getCurrentUpgradeWelfareByParams(array $params)
 * @method getUserMedalsByParams(array $params)
 * @method memberConfirmByParams(array $params)
 * @method receiveMedalByParams(array $params)
 */
class HimoMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建用户流水
     *
     * @support  string $type 流水类型 [ require false ]
     * @support  string $source 订单来源 [ require true ]
     * @support  float $money 金额 [ require true ]
     * @param  int $userId 用户uid [ require true ]
     * @support  int $diffId 扩展ID [ require false ]
     * @support  int $orderId 订单id [ require true ]
     * @support  string $orderCreatedAt 创建时间 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderFlow (int $userId) {
        return self::getClass()->createOrderFlow([
            "userId" => $userId,
        ]);
    }

    /**
     * 创建用户流水
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  array $flowRecords 流水记录 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function batchCreateOrderFlow (int $userId, array $flowRecords) {
        return self::getClass()->batchCreateOrderFlow([
            "userId" => $userId,
            "flowRecords" => $flowRecords,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  int $userId 用户id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $userId, int $orderId) {
        return self::getClass()->bindOrder([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 解绑订单
     *
     * @param  int $orderId 订单id [ require true ]
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindOrder (int $userId, int $orderId) {
        return self::getClass()->unbindOrder([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 通过积分或消费次数的计算等级
     *
     * @param  int $integral 积分 [ require true ]
     * @param  int $consumeNum 消费次数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calcLevel (int $integral, int $consumeNum) {
        return self::getClass()->calcLevel([
            "integral" => $integral,
            "consumeNum" => $consumeNum,
        ]);
    }

    /**
     * 查询用户升级目标
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserUpgradeTarget (int $userId) {
        return self::getClass()->getUserUpgradeTarget([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员列表-分页
     *
     * @support  array $userIds 用户ids [ require false ]
     * @support  array $levels 会员等级 [ require false ]
     * @support  array $consumeNumExp 消费次数表达式 [ require false ]
     * @support  string $birthStart 生日筛选 [ require false ]
     * @support  string $birthEnd 生日筛选 [ require false ]
     * @support  string $lastBuyTime 最后购买时间 [ require false ]
     * @support  string $lastBuyTimeStart 最后消费时间-开始 [ require false ]
     * @support  string $lastBuyTimeEnd 最后消费时间-结束 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMembers (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getMembers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 会员详情
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMemberInfo (int $userId) {
        return self::getClass()->getMemberInfo([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员列表
     *
     * @support  array $userIds 用户ids [ require false ]
     * @support  array $levels 会员等级 [ require false ]
     * @support  array $consumeNumExp 消费次数表达式 [ require false ]
     * @support  string $birthStart 生日筛选 [ require false ]
     * @support  string $birthEnd 生日筛选 [ require false ]
     * @support  string $lastBuyTime 最后购买时间 [ require false ]
     * @support  string $lastBuyTimeStart 最后消费时间-开始 [ require false ]
     * @support  string $lastBuyTimeEnd 最后消费时间-结束 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 修改会员相关信息
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  string $birthYear 用户生日年份 [ require false ]
     * @support  string $birthDate 会员生日 月日 [ require false ]
     * @support  bool $enablePush 是否开启推送 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $userId) {
        return self::getClass()->update([
            "userId" => $userId,
        ]);
    }

    /**
     * 会员规则查询
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMemberRule () {
        return self::getClass()->getMemberRule();
    }

    /**
     * 使用会员加急次数
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $orderId 订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function useExpeditedTimes (int $userId, int $orderId) {
        return self::getClass()->useExpeditedTimes([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取当前用户的升级体验权益
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  string $brand 品牌 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCurrentUpgradeWelfare (int $userId) {
        return self::getClass()->getCurrentUpgradeWelfare([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取用户勋章
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  array $multiStatus 多状态 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserMedals () {
        return self::getClass()->getUserMedals([
        ]);
    }

    /**
     * 勋章确认
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  array $recordIds 记录IDs [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberConfirm (int $userId, array $recordIds) {
        return self::getClass()->memberConfirm([
            "userId" => $userId,
            "recordIds" => $recordIds,
        ]);
    }

    /**
     * 勋章领取
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $medalId 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMedal (int $userId, int $medalId) {
        return self::getClass()->receiveMedal([
            "userId" => $userId,
            "medalId" => $medalId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}