<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method existByParams(array $params)
 */
class MemberEvent {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 事件记录
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $name 标记名称 [ require true ]
     * @support  mixed $content 标记内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function save () {
        return self::getClass()->save([
        ]);
    }

    /**
     * 事件查询
     *
     * @support  array $userIds 用户IDs [ require false ]
     * @support  string $name 事件名称 [ require false ]
     * @support  array $names 事件名称s [ require false ]
     * @support  string $createdAtStart 创建时间开始 [ require false ]
     * @support  string $createdAtEnd 创建时间结束 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list([
        ]);
    }

    /**
     * 修改事件
     *
     * @param  int $eventId 事件名称 [ require true ]
     * @support  string $name 名称 [ require false ]
     * @support  string $content 内容 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $eventId) {
        return self::getClass()->update([
            "eventId" => $eventId,
        ]);
    }

    /**
     * 删除事件
     *
     * @param  int $eventId 事件id [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $eventId) {
        return self::getClass()->delete([
            "eventId" => $eventId,
        ]);
    }

    /**
     * 验证事件是否存在
     *
     * @support  int $userId 用户id [ require true ]
     * @support  string $name 事件名称 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function exist () {
        return self::getClass()->exist([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MemberEvent');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MemberEvent');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}