<?php
namespace Mainto\Bridge\Invokes\UserMember\MilestoneWelfare;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method infoByParams(array $params)
 * @method allByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareAllCMD $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareListCMD $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareCreateCMD $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateCMD $params)
 * @method updateStateByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateStateCMD $params)
 * @method deleteByIdsByParams(array $params)
 */
class MilestoneWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 里程碑详情
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareInfoDTO
     */
    public static function info (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareInfoDTO"
        );
    }

    /**
     * 获取全部里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareAllCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareAllDTO
     */
    public static function all (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareAllCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareAllDTO"
        );
    }


    /**
     * 分页获取里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareListCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareListDTO
     */
    public static function list (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareListCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareListDTO"
        );
    }


    /**
     * 创建里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareCreateCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareInfoDTO
     */
    public static function create (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareCreateCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareInfoDTO"
        );
    }


    /**
     * 编辑里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateCMD $CMD) {
        return self::getClass()->update($CMD);
    }


    /**
     * 里程碑福利上下架
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateStateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareUpdateStateCMD $CMD) {
        return self::getClass()->updateState($CMD);
    }


    /**
     * 删除里程碑福利
     *
     * @param  array $ids 里程碑id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function deleteByIds (array $ids) {
        return self::getClass()->deleteByIds([
            "ids" => $ids,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'MilestoneWelfare\MilestoneWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'MilestoneWelfare\MilestoneWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}