<?php
namespace Mainto\Bridge\Invokes\UserMember\MilestoneWelfare;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method allByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordAllCMD $params)
 * @method listByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordListCMD $params)
 * @method getExchangeNumByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeNumCMD $params)
 * @method getExchangeWelfareNumByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeWelfareNumCMD $params)
 * @method createByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordCreateCMD $params)
 */
class MilestoneWelfareRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取全部里程碑福利兑换记录
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordAllCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordAllDTO
     */
    public static function all (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordAllCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordAllDTO"
        );
    }


    /**
     * 分页获取里程碑福利兑换记录
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordListCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordListDTO
     */
    public static function list (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordListCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->list($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordListDTO"
        );
    }


    /**
     * 获取用户兑换次数
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeNumCMD $CMD
     * @throws  \Exception
     * @return  int
     */
    public static function getExchangeNum (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeNumCMD $CMD) {
        return self::getClass()->getExchangeNum($CMD);
    }


    /**
     * 获取里程碑福利兑换数量
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeWelfareNumCMD $CMD
     * @throws  \Exception
     * @return  int
     */
    public static function getExchangeWelfareNum (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordExchangeWelfareNumCMD $CMD) {
        return self::getClass()->getExchangeWelfareNum($CMD);
    }


    /**
     * 创建里程碑福利兑换记录
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordCreateCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordInfoDTO
     */
    public static function create (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneWelfareRecordCreateCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneWelfareRecordInfoDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'MilestoneWelfare\MilestoneWelfareRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'MilestoneWelfare\MilestoneWelfareRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}