<?php
namespace Mainto\Bridge\Invokes\UserMember\MilestoneWelfare;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneCreateCMD $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateCMD $params)
 * @method updateStateByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateStateCMD $params)
 * @method infoByParams(array $params)
 * @method allByParams(array|\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneAllCMD $params)
 */
class Milestone {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneCreateCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneInfoDTO
     */
    public static function create (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneCreateCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->create($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneInfoDTO"
        );
    }


    /**
     * 编辑里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateCMD $CMD) {
        return self::getClass()->update($CMD);
    }


    /**
     * 里程碑上下架
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateStateCMD $CMD
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneUpdateStateCMD $CMD) {
        return self::getClass()->updateState($CMD);
    }


    /**
     * 里程碑详情
     *
     * @param  int $id 里程碑id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneInfoDTO
     */
    public static function info (int $id) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->info([
                            "id" => $id,
                        ]),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneInfoDTO"
        );
    }

    /**
     * 获取全部里程碑
     *
     * @var  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneAllCMD $CMD
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneAllDTO
     */
    public static function all (\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\CMD\MilestoneAllCMD $CMD) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->all($CMD),
            "\Mainto\Bridge\Structs\UserMember\MilestoneWelfare\DTO\MilestoneAllDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'MilestoneWelfare\Milestone');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'MilestoneWelfare\Milestone');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}