<?php
namespace Mainto\Bridge\Enums\UserMember;

class HimoMemberLevelEnum {
    /**
     * 蓝卡会员
     */
    const LEVEL_BLUE = 'blue';
    /**
     * 银卡会员
     */
    const LEVEL_SILVER = 'silver';
    /**
     * 金卡会员
     */
    const LEVEL_GOLD = 'gold';
    /**
     * 黑卡会员
     */
    const LEVEL_BLACK = 'black';
    /**
     * 普通会员
     */
    const LEVEL_NORMAL = 'normal';
    /**
     * 新鲜人
     */
    const FRESHMAN = 'v1';
    /**
     * 爱好者
     */
    const LOVERS = 'v2';
    /**
     * 圈内人
     */
    const INSIDER = 'v3';
    /**
     * 艺术家
     */
    const ARTIST = 'v4';
    /**
     * 会员所有等级
     */
    const ALL_LEVEL = [0 => 'blue',1 => 'gold',2 => 'black',3 => 'normal',4 => 'silver'];
    /**
     * 会员等级排序
     */
    const RANK_LEVEL = [0 => 'normal',1 => 'blue',2 => 'silver',3 => 'gold',4 => 'black'];
    /**
     * 所有会员类型
     */
    const ALL_LEVELS = [0 => 'v1',1 => 'v2',2 => 'v3',3 => 'v4'];
    /**
     * 高等级类型
     */
    const ALL_HIGH_LEVEL_TYPES = [0 => 'silver',1 => 'gold',2 => 'black'];
}