<?php
namespace Mainto\Bridge\Invokes\UserMember\CpMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCpMemberInfoByParams(array|\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberInfoCmd $params)
 * @method createByParams(array $params)
 * @method updateByParams(array|\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberUpdateCmd $params)
 * @method getScoreCyCleByParams(array $params)
 */
class CpMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取情侣会员信息
     *
     * @var  \Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberInfoCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberInfoDTO
     */
    public static function getCpMemberInfo (\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberInfoCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberInfo($cmd),
            "\Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberInfoDTO"
        );
    }


    /**
     * 创建情侣会员
     *
     * @param  int $userId 会员id [ require true ]
     * @param  int $orderId 订单id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function create (int $userId, int $orderId) {
        return self::getClass()->create([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 编辑情侣会员
     *
     * @var  \Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberUpdateCmd $cmd
     * @throws  \Exception
     * @return  bool
     */
    public static function update (\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberUpdateCmd $cmd) {
        return self::getClass()->update($cmd);
    }


    /**
     * 情侣会员分值周期
     *
     * @param  int $userId 情侣会员id [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreCycleDTO
     */
    public static function getScoreCyCle (int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getScoreCyCle([
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreCycleDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'CpMember\CpMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'CpMember\CpMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}