<?php
namespace Mainto\Bridge\Invokes\UserMember\CpMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCpMemberScoreAllByParams(array|\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreAllCmd $params)
 * @method getCpMemberScoreListByParams(array|\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreListCmd $params)
 */
class CpMemberScore {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取情侣会员分值记录
     *
     * @var  \Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreAllCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreInfoDTO[]
     */
    public static function getCpMemberScoreAll (\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreAllCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberScoreAll($cmd),
            "\Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreInfoDTO[]"
        );
    }


    /**
     * 分页获取情侣会员分值记录
     *
     * @var  \Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreListDTO
     */
    public static function getCpMemberScoreList (\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\CpMemberScoreListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberScoreList($cmd),
            "\Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'CpMember\CpMemberScore');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'CpMember\CpMemberScore');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}