<?php
namespace Mainto\Bridge\Invokes\UserMember\CpMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getCpMemberScoreLogsListByParams(array|\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\cpMemberScoreLogsListCmd $params)
 */
class CpMemberScoreLog {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取情侣会员分值记录日志列表
     *
     * @var  \Mainto\Bridge\Structs\UserMember\CpMember\Cmd\cpMemberScoreLogsListCmd $cmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreLogsListDTO
     */
    public static function getCpMemberScoreLogsList (\Mainto\Bridge\Structs\UserMember\CpMember\Cmd\cpMemberScoreLogsListCmd $cmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getCpMemberScoreLogsList($cmd),
            "\Mainto\Bridge\Structs\UserMember\CpMember\DTO\CpMemberScoreLogsListDTO"
        );
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'CpMember\CpMemberScoreLog');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'CpMember\CpMemberScoreLog');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}