<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method memberReviewByParams(array $params)
 * @method resetAllMembersExpeditedWelfareByParams(array $params)
 * @method medalVerificationByParams(array $params)
 * @method pointsClearedByParams(array $params)
 * @method delayPointClearedTimeByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 会员年审-每隔十分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberReview () {
        return self::getClass()->memberReview();
    }

    /**
     * 重置会员加急次数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetAllMembersExpeditedWelfare () {
        return self::getClass()->resetAllMembersExpeditedWelfare();
    }

    /**
     * 核对勋章
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalVerification () {
        return self::getClass()->medalVerification();
    }

    /**
     * 1月1-5号每隔15秒执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function pointsCleared () {
        return self::getClass()->pointsCleared();
    }

    /**
     * 这个定时任务需要在年度积分清零之后执行
     * 留一个月缓冲时间，假设年度积分清零有遗漏的话，这期间还能通过实时方案清零
     * 2月1号凌晨1点执行一次
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function delayPointClearedTime () {
        return self::getClass()->delayPointClearedTime();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}