<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method getAllNormalTemplateByParams(array $params)
 * @method infoByParams(array $params)
 */
class MilestoneWelfareOtherCouponTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建三方券码模版
     *
     * @support  string $name 模版名称 [ require false ]
     * @support  string $source 来源 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @support  string $expiredTime 过期时间 [ require false ]
     * @support  array $extend 扩展数据 [ require false ]
     * @support  array $templateCode 三方券码 [ require false ]
     * @throws  \Exception
     * @return  int
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 获取全部有效的三方券码模版
     *
     * @param  string $source 来源 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getAllNormalTemplate (string $source = 'youzan') {
        return self::getClass()->getAllNormalTemplate([
            "source" => $source,
        ]);
    }

    /**
     * 获取三方券码模版信息
     *
     * @param  int $id 三方券码模版id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MilestoneWelfareOtherCouponTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MilestoneWelfareOtherCouponTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}