<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method listByParams(array $params)
 * @method infoByParams(array $params)
 * @method allByParams(array $params)
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method updateStateByParams(array $params)
 * @method getWelfareInventoryCountByParams(array $params)
 * @method deleteByParams(array $params)
 */
class MilestoneWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取里程碑福利数据 分页
     *
     * @support  int $milestoneId 里程碑阶梯id [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  string $state 上下架 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function list (int $page = 1, int $pageSize = 15) {
        return self::getClass()->list([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取单条里程碑数据
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $id) {
        return self::getClass()->info([
            "id" => $id,
        ]);
    }

    /**
     * 获取里程碑福利数据
     *
     * @support  int $milestoneId 里程碑阶梯id [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  string $state 上下架 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function all () {
        return self::getClass()->all([
        ]);
    }

    /**
     * 创建里程碑福利
     *
     * @support  int $milestoneId 里程碑阶梯id [ require true ]
     * @support  string $name 名称 [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  int $count 库存 [ require false ]
     * @support  array $memberLevel 等级 [ require false ]
     * @support  int $initCount 兑换人数假数据 [ require true ]
     * @support  int $sort 排序值 [ require false ]
     * @support  array $extend 扩展数据 [ require true ]
     * @support  string $state 上下架状态 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create([
        ]);
    }

    /**
     * 编辑里程碑福利
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @support  string $name 名称 [ require false ]
     * @support  string $preferentialType 福利类型 [ require false ]
     * @support  int $count 库存 [ require false ]
     * @support  int $isResetInventory 是否重置库存 [ require false ]
     * @support  array $memberLevel 等级 [ require false ]
     * @support  int $initCount 兑换人数假数据 [ require true ]
     * @support  int $sort 排序值 [ require false ]
     * @support  array $extend 扩展数据 [ require true ]
     * @support  string $state 上下架状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 里程碑福利上下架
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @param  string $state 上下架状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function updateState (int $id, string $state) {
        return self::getClass()->updateState([
            "id" => $id,
            "state" => $state,
        ]);
    }

    /**
     * 获取福利剩余库存
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  int
     */
    public static function getWelfareInventoryCount (int $id) {
        return self::getClass()->getWelfareInventoryCount([
            "id" => $id,
        ]);
    }

    /**
     * 删除里程碑福利
     *
     * @param  int $id 里程碑福利id [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MilestoneWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MilestoneWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}