<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method memberReviewByParams(array $params)
 * @method userIdsToRedisByParams(array $params)
 * @method pointsCleanupByParams(array $params)
 * @method resetAllMembersExpeditedWelfareByParams(array $params)
 * @method resetMembersAfterPointsCleanupByParams(array $params)
 * @method medalVerificationByParams(array $params)
 */
class Task {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 会员年审-每隔十分钟执行一次
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberReview () {
        return self::getClass()->memberReview();
    }

    /**
     * 2年前的纪念值变更的用户放入 redis 中
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function userIdsToRedis () {
        return self::getClass()->userIdsToRedis();
    }

    /**
     * 清除2年前的纪念值变更记录
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function pointsCleanup () {
        return self::getClass()->pointsCleanup();
    }

    /**
     * 重置会员加急次数
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetAllMembersExpeditedWelfare () {
        return self::getClass()->resetAllMembersExpeditedWelfare();
    }

    /**
     * 积分清除-本年度12月31日清自然年2年前的纪念值-清掉基础和奖励
     *
     * @throws  \Exception
     * @return  bool
     */
    public static function resetMembersAfterPointsCleanup () {
        return self::getClass()->resetMembersAfterPointsCleanup();
    }

    /**
     * 核对勋章
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function medalVerification () {
        return self::getClass()->medalVerification();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Task');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Task');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}