<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method exchangeWelfareByParams(array $params)
 * @method getMemberExchangeListByParams(array $params)
 * @method getMemberExchangeWelfareCountByParams(array $params)
 * @method getExchangeNumByParams(array $params)
 */
class MemberMilestoneWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 用户积分兑换福利
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  int $milestoneWelId 福利ID [ require true ]
     * @param  int $integral 积分 [ require true ]
     * @support  int $num 数量 [ require true ]
     * @support  array $extend 扩展字段 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function exchangeWelfare (int $userId, int $integral) {
        return self::getClass()->exchangeWelfare([
            "userId" => $userId,
            "integral" => $integral,
        ]);
    }

    /**
     * 用户兑换的记录查询
     *
     * @support  int $userId 用户ID [ require true ]
     * @support  int $milestoneWelId 福利ID [ require false ]
     * @support  array $createArea 时间范围搜索 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 条数 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMemberExchangeList (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getMemberExchangeList([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 用户id兑换福利的总数(可能一次兑换两个)
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMemberExchangeWelfareCount (int $userId) {
        return self::getClass()->getMemberExchangeWelfareCount([
            "userId" => $userId,
        ]);
    }

    /**
     * 兑换次数
     *
     * @support  int $userId 用户ID [ require false ]
     * @support  int $milestoneWelId 福利ID [ require false ]
     * @support  array $createArea 时间范围搜索 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getExchangeNum () {
        return self::getClass()->getExchangeNum([
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MemberMilestoneWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MemberMilestoneWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}