<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showPicFinishOrderByParams(array $params)
 * @method updateLastSpendEventByParams(array $params)
 * @method memberExpeditedWelfareByParams(array $params)
 * @method sendHimoOrderRelatedMedalsByParams(array $params)
 * @method withdrawMedalsByParams(array $params)
 * @method sendShowPicOrderRelatedMedalsByParams(array $params)
 * @method userInvitationByParams(array $params)
 * @method userShowSelectionByParams(array $params)
 * @method userPerfectInformationByParams(array $params)
 * @method userHeadquarterSampleByParams(array $params)
 * @method remakeOrderPointsChangeByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽订单完成
     *
     * @param  int $user_id 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showPicFinishOrder (int $user_id) {
        return self::getClass()->showPicFinishOrder([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 蓝标、金标、kids、缦图摄影订单完成
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $source 类型 [ require true ]
     * @param  string $type 流水类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateLastSpendEvent (int $userId, string $source, string $type) {
        return self::getClass()->updateLastSpendEvent([
            "userId" => $userId,
            "source" => $source,
            "type" => $type,
        ]);
    }

    /**
     * 会员加急权益【降级做等级权益处理(减少)，升级保持权益】
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $change 等级变更类型 [ require true ]
     * @param  string $currentLevel 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberExpeditedWelfare (int $userId, string $change, string $currentLevel) {
        return self::getClass()->memberExpeditedWelfare([
            "userId" => $userId,
            "change" => $change,
            "currentLevel" => $currentLevel,
        ]);
    }

    /**
     * 完成订单服务-缦图业务订单
     *
     * @support  int $orderId 订单ID [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @support  array $orderSkuList 产品信息 [ require true ]
     * @support  string $source 消费来源 [ require false ]
     * @support  string $status 状态 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendHimoOrderRelatedMedals () {
        return self::getClass()->sendHimoOrderRelatedMedals([
        ]);
    }

    /**
     * 全款退款订单-缦图业务订单
     *
     * @support  int $orderId 订单内容 [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @support  string $status 状态 [ require false ]
     * @support  string $source 消费来源 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function withdrawMedals () {
        return self::getClass()->withdrawMedals([
        ]);
    }

    /**
     * 完成订单服务-修修兽业务订单
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  float $money 消费金额 [ require true ]
     * @support  int $orderId 消费订单ID [ require true ]
     * @support  string $status 状态 [ require false ]
     * @support  string $source 消费来源 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function sendShowPicOrderRelatedMedals (int $userId) {
        return self::getClass()->sendShowPicOrderRelatedMedals([
            "userId" => $userId,
        ]);
    }

    /**
     * 邀请用户-勋章处理
     *
     * @param  int $userId 邀请人用户ID [ require true ]
     * @param  int $inviteNum 邀请数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function userInvitation (int $userId, int $inviteNum) {
        return self::getClass()->userInvitation([
            "userId" => $userId,
            "inviteNum" => $inviteNum,
        ]);
    }

    /**
     * 买家秀精选-勋章处理
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $setStarNum 精选数量 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function userShowSelection (int $userId, int $setStarNum) {
        return self::getClass()->userShowSelection([
            "userId" => $userId,
            "setStarNum" => $setStarNum,
        ]);
    }

    /**
     * 完善用户信息-勋章处理
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function userPerfectInformation (int $userId) {
        return self::getClass()->userPerfectInformation([
            "userId" => $userId,
        ]);
    }

    /**
     * 总部样片-勋章处理
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function userHeadquarterSample (int $userId) {
        return self::getClass()->userHeadquarterSample([
            "userId" => $userId,
        ]);
    }

    /**
     * 重拍订单相关的积分信息通知
     *
     * @param  int $orderId 订单id [ require true ]
     * @support  int $retakeAfterOrderId 重拍后的订单id [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @support  bool $skuAllRetake 是否全部重拍 [ require true ]
     * @support  string $source 订单所属模块 [ require true ]
     * @support  array $orderDiffInfo 积分详情 [ require false ]
     * @throws  \Exception
     * @return  bool
     */
    public static function remakeOrderPointsChange (int $orderId, int $userId) {
        return self::getClass()->remakeOrderPointsChange([
            "orderId" => $orderId,
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}