<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getSeriesByParams(array $params)
 * @method getSeriesForPageByParams(array $params)
 */
class MedalSeries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建系列
     *
     * @param  string $name 系列名称 [ require true ]
     * @param  int $sort 排序 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, int $sort = 0) {
        return self::getClass()->create([
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id 系列ID [ require true ]
     * @support  string $name 系列名称 [ require false ]
     * @support  int $sort 排序 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update ($context, int $id) {
        return self::getClass()->update([
            "context" => $context,
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 系列ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 上线
     *
     * @param  int $id 系列ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 下线
     *
     * @param  int $id 系列ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 系列查询
     *
     * @support  string $name 系列名称 [ require false ]
     * @support  string $status 系列状态 [ require false ]
     * @support  bool $withDel 包含软删除 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @support  array $seriesIds 系列ids [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSeries ($context) {
        return self::getClass()->getSeries([
            "context" => $context,
        ]);
    }

    /**
     * 系列查询分页
     *
     * @support  array $ids 系列ids [ require false ]
     * @support  string $name 系列名称 [ require false ]
     * @support  string $status 系列状态 [ require false ]
     * @support  bool $withDel 包含软删除 [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @param  int $page 分页 [ require false ]
     * @param  int $pageSize 每页数量 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSeriesForPage ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getSeriesForPage([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}