<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveMemberInfoByRegisterByParams(array $params)
 * @method saveMemberInfoByConsumeByParams(array $params)
 * @method firstLoginMemberByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存用户会员信息[注册]
     *
     * @support  int $user_id 用户ID [ require true ]
     * @support  string $tag_content 标记内容 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveMemberInfoByRegister ($context) {
        return self::getClass()->saveMemberInfoByRegister([
            "context" => $context,
        ]);
    }

    /**
     * 保存用户会员信息【消费】- 修修兽
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  string $source 来源 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function saveMemberInfoByConsume (int $userId, string $source) {
        return self::getClass()->saveMemberInfoByConsume([
            "userId" => $userId,
            "source" => $source,
        ]);
    }

    /**
     * fixme 无法确认是否是首次登录，目前实现是要海马体的用户登录都会验证一遍
     *
     * @param  string $brand 登录平台 [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function firstLoginMember (int $userId, string $brand) {
        return self::getClass()->firstLoginMember([
            "userId" => $userId,
            "brand" => $brand,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}