<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getMemberCardsByParams(array $params)
 * @method detailByParams(array $params)
 * @method bulkOpenByParams(array $params)
 * @method bulkForbiddenByParams(array $params)
 * @method listByParams(array $params)
 * @method memberStudentIdentityChangeByParams(array $params)
 */
class MemberCard {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取会员卡列表--分页
     *
     * @support  string $receiveTimeStart 领取时间-开始时间 [ require false ]
     * @support  string $receiveTimeEnd 领取时间-结束时间 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @support  array $userIds 用户Ids [ require false ]
     * @support  array $templateIds 模板Ids [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @param  int $page 页数 [ require false ]
     * @param  int $pageSize 分页数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMemberCards ($context, int $page = 1, int $pageSize = 20) {
        return self::getClass()->getMemberCards([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取会员卡详情
     *
     * @support  int $cardId 会员卡ID [ require true ]
     * @support  bool $withCardTemplate 是否携带会员卡模板信息 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function detail ($context) {
        return self::getClass()->detail([
            "context" => $context,
        ]);
    }

    /**
     * 会员卡批量开启
     *
     * @support  array $cardIds 批量开启的会员卡ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkOpen ($context) {
        return self::getClass()->bulkOpen([
            "context" => $context,
        ]);
    }

    /**
     * 会员卡批量禁用
     *
     * @support  array $cardIds 批量禁用的会员卡ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bulkForbidden ($context) {
        return self::getClass()->bulkForbidden([
            "context" => $context,
        ]);
    }

    /**
     * 获取会员卡列表
     *
     * @support  string $receiveTimeStart 领取时间-开始时间 [ require false ]
     * @support  string $receiveTimeEnd 领取时间-结束时间 [ require false ]
     * @support  string $state 状态 [ require false ]
     * @support  array $userIds 用户Ids [ require false ]
     * @support  array $templateIds 模板Ids [ require false ]
     * @support  array $sortBy 排序字段 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 学生会员身份变更
     *
     * @param  int $userId 用户ID [ require true ]
     * @param  int $status 状态 [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function memberStudentIdentityChange (int $userId, int $status) {
        return self::getClass()->memberStudentIdentityChange([
            "userId" => $userId,
            "status" => $status,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'MemberCard');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'MemberCard');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}