<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getInfoByTemplateIdByParams(array $params)
 * @method getMemberCardTemplatesByParams(array $params)
 * @method modifyStateToUpByParams(array $params)
 * @method modifyStateToDownByParams(array $params)
 * @method listByParams(array $params)
 */
class MemberCardTemplate {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建会员卡模板
     *
     * @support  string $title 会员卡名称 [ require true ]
     * @support  int $createBy 操作人ID [ require true ]
     * @support  string $cardType 会员卡类型 [ require true ]
     * @support  string $identity 会员身份 [ require true ]
     * @support  int $total 会员卡发行数量 [ require true ]
     * @support  string $pushTime 发行时间 [ require true ]
     * @support  string $gainType 权益类型 [ require true ]
     * @support  array $gainConfig 权益配置 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改会员卡模板
     *
     * @support  int $templateId 会员卡模板ID [ require true ]
     * @support  int $createBy 操作人ID [ require true ]
     * @support  string $title 会员卡名称 [ require true ]
     * @support  string $cardType 会员卡类型 [ require true ]
     * @support  string $identity 会员身份 [ require true ]
     * @support  int $total 会员卡发行数量 [ require true ]
     * @support  string $pushTime 发行时间 [ require true ]
     * @support  string $gainType 权益类型 [ require true ]
     * @support  array $gainConfig 权益配置 require false
     * @throws  \Exception
     * @return  bool
     */
    public static function update () {
        return self::getClass()->update();
    }

    /**
     * 获取1条会员卡模板
     *
     * @param  int $templateId 会员卡模板ID [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getInfoByTemplateId (int $templateId) {
        return self::getClass()->getInfoByTemplateId([
            "templateId" => $templateId,
        ]);
    }

    /**
     * 获取会员卡模板分页数据
     *
     * @support  string $type 会员卡类型 require false
     * @support  string $identity 会员身份 require false
     * @support  string $state 状态，up = 已上架，down = 已下架 require false
     * @support  string $templateName 会员卡模板名称 require false
     * @support  string $releaseStartTime 发行时间 - 开始日期 require false
     * @support  string $releaseEndTime 发行时间 - 结束日期 require false
     * @support  string $createStartTime 创建时间 - 开始日期 require false
     * @support  string $createEndTime 创建时间 - 结束日期 require false
     * @support  array $sortBy 排序字段 require false
     * @support  int $page 页数 require false
     * @support  int $pageSize 分页数 require false
     * @throws  \Exception
     * @return  array
     */
    public static function getMemberCardTemplates () {
        return self::getClass()->getMemberCardTemplates();
    }

    /**
     * 上架会员卡模板
     *
     * @param  int $templateId 会员卡模板ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyStateToUp (int $templateId) {
        return self::getClass()->modifyStateToUp([
            "templateId" => $templateId,
        ]);
    }

    /**
     * 下架会员卡模板
     *
     * @param  int $templateId 会员卡模板ID [ require true ]
     * @throws  \Exception
     * @return  bool
     */
    public static function modifyStateToDown (int $templateId) {
        return self::getClass()->modifyStateToDown([
            "templateId" => $templateId,
        ]);
    }

    /**
     * 获取会员卡模板列表数据
     *
     * @support  array $templateIds 模板id列表 require false
     * @support  string $type 会员卡类型 require false
     * @support  string $templateName 会员卡模板名称 require false
     * @throws  \Exception
     * @return  array
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'MemberCardTemplate');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'MemberCardTemplate');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}