<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receivePointsByParams(array $params)
 * @method getPointsByParams(array $params)
 * @method listByParams(array $params)
 * @method getCleanablePointsByParams(array $params)
 */
class Points {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 领取积分
     * @deprecated
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  int $outId 活动ID [ require true ]
     * @support  int $points 积分 [ require false ]
     * @support  string $type 积分类型 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePoints ($context, int $userId) {
        return self::getClass()->receivePoints([
            "context" => $context,
            "userId" => $userId,
        ]);
    }

    /**
     * 积分变更查询-分页
     *
     * @support  array $types 类型s [ require false ]
     * @support  int $outId 外部关联ID [ require false ]
     * @support  int $userId 用户Id [ require false ]
     * @support  array $userIds 用户Ids [ require false ]
     * @support  string $createdAtStart 创建时间-开始 [ require false ]
     * @support  string $createdAtEnd 创建时间-截止 [ require false ]
     * @support  string $createdAtEnd 创建时间-截止 [ require false ]
     * @support  string $createdAtEnd 创建时间-截止 [ require false ]
     * @support  array $sortScope 排序作用域 [ require false ]
     * @param  int $page 页码 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getPoints ($context, int $page = 1, int $pageSize = 10) {
        return self::getClass()->getPoints([
            "context" => $context,
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 积分变更查询-不分页
     *
     * @support  array $types 类型s [ require false ]
     * @support  string $type 类型 [ require false ]
     * @support  int $userId 用户Id [ require false ]
     * @support  int $outId 外部关联ID [ require false ]
     * @support  array $outIds 外部关联IDs [ require false ]
     * @support  bool $withDel 是否包含删除 [ require false ]
     * @support  string $createdAtEnd 创建时间-截止 [ require false ]
     * @support  string $createdAtStart 创建时间-开始 [ require false ]
     * @support  array $sortScope 排序作用域 [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function list ($context) {
        return self::getClass()->list([
            "context" => $context,
        ]);
    }

    /**
     * 获取用户待清理积分
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getCleanablePoints (int $userId) {
        return self::getClass()->getCleanablePoints([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\Points');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\Points');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}