<?php
namespace Mainto\Bridge\Invokes\UserMember\ShowPic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method finishFlowRecordByParams(array $params)
 * @method closeFlowRecordByParams(array $params)
 * @method infoByParams(array $params)
 * @method queryShowPicMembersByParams(array $params)
 */
class ShowPicMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽-完成订单记录流水
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  float $money 消费金额 [ require true ]
     * @support  int $orderId 消费订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function finishFlowRecord (int $userId) {
        return self::getClass()->finishFlowRecord([
            "userId" => $userId,
        ]);
    }

    /**
     * 修修兽-关闭订单记录流水
     *
     * @param  int $userId 用户ID [ require true ]
     * @support  float $money 消费金额 [ require true ]
     * @support  int $orderId 消费订单ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function closeFlowRecord (int $userId) {
        return self::getClass()->closeFlowRecord([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取用户消费详情
     *
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function info (int $userId) {
        return self::getClass()->info([
            "userId" => $userId,
        ]);
    }

    /**
     * 修修兽会员列表查询分页
     *
     * @support  string $createdAtStart 使用时间起 require false
     * @support  string $createdAtEnd 使用时间止 require false
     * @support  array $userIds 用户IDs require false
     * @support  string $orderColumn 排序列 require false
     * @support  string $orderDirect 排序方向 require false
     * @support  string $source 来源 require false
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function queryShowPicMembers (int $page = 1, int $pageSize = 10) {
        return self::getClass()->queryShowPicMembers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'ShowPic\ShowPicMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'ShowPic\ShowPicMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}