<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method attachOrderFlowByParams(array $params)
 * @method attachPointsByParams(array $params)
 * @method resetMemberByParams(array $params)
 */
class FixMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 配合订单修复用户流水
     *
     * @support  string $type 流水类型 require false
     * @support  string $source 订单来源 require false
     * @param  int $userId 用户uid [ require true ]
     * @support  int $orderId 订单id [ require true ]
     * @support  string $createdAt 创建时间 [ require true ]
     * @support  int $orderDiffId 扩展ID require false
     * @support  float $consumeAmount 金额 [ require true ]
     * @support  bool $isNewOrder 是否是新订单 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function attachOrderFlow (int $userId) {
        return self::getClass()->attachOrderFlow([
            "userId" => $userId,
        ]);
    }

    /**
     * 补充记录流水【之前存在消费但是未纪录积分的】
     *
     * @param  int $recordId 记录ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function attachPoints (int $recordId) {
        return self::getClass()->attachPoints([
            "recordId" => $recordId,
        ]);
    }

    /**
     * 重算会员积分
     *
     * @param  int $userId 会员ID [ require true ]
     * @param  string $dateStart 开始时间 [ require true ]
     * @param  string $dateEnd 截止时间 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function resetMember (int $userId, string $dateStart, string $dateEnd) {
        return self::getClass()->resetMember([
            "userId" => $userId,
            "dateStart" => $dateStart,
            "dateEnd" => $dateEnd,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'FixMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'FixMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}