<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getMedalsByParams(array $params)
 * @method getMedalsForPageByParams(array $params)
 * @method getInfoByParams(array $params)
 */
class MemberMedal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建勋章
     *
     * @support  string $name 勋章名称 [ require true ]
     * @support  string $type 勋章类型 require false
     * @support  int $rank 勋章等级 require false
     * @support  int $sort 排序 require false
     * @support  int $seriesId 系列名称 [ require true ]
     * @support  int $parentId 父级勋章ID require false
     * @support  array $content 勋章内容 require false
     * @support  int $createBy 创建人 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改勋章
     *
     * @param  int $medalId 勋章ID [ require true ]
     * @support  string $name 勋章名称 [ require true ]
     * @support  int $rank 勋章等级 require false
     * @support  int $seriesId 系列名称 [ require true ]
     * @support  int $parentId 父级勋章ID require false
     * @support  array $content 内容 require false
     * @support  int $sort 排序 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $medalId) {
        return self::getClass()->update([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 删除勋章
     *
     * @param  int $medalId 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $medalId) {
        return self::getClass()->delete([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 上线勋章
     *
     * @param  int $medalId 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $medalId) {
        return self::getClass()->online([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 下线勋章
     *
     * @param  int $medalId 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $medalId) {
        return self::getClass()->offline([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 获取勋章列表
     *
     * @support  int $rank 勋章等级 require false
     * @support  string $status 勋章状态 require false
     * @support  bool $withDel 包含软删除 require false
     * @support  array $sortBy 排序字段 require false
     * @support  int $seriesId 系列ID require false
     * @support  int $parentId 父级ID require false
     * @support  array $medalIds 勋章ids require false
     * @support  array $parentIds 勋章父级ids require false
     * @support  string $medalName 勋章查询 require false
     * @support  string $relatedType 关联类型 require false
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedals () {
        return self::getClass()->getMedals();
    }

    /**
     * 获取勋章列表
     *
     * @support  int $rank 勋章等级 require false
     * @support  string $status 勋章状态 require false
     * @support  bool $withDel 包含软删除 require false
     * @support  array $sortBy 排序字段 require false
     * @support  int $seriesId 系列ID require false
     * @support  int $parentId 父级ID require false
     * @support  array $medalIds 勋章ids require false
     * @support  array $parentIds 勋章父级ids require false
     * @support  string $medalName 勋章查询 require false
     * @support  string $relatedType 关联类型 require false
     * @param  int $page 分页 [ require true ]
     * @param  int $pageSize 每页数量 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getMedalsForPage (int $page = 1, int $pageSize = 10) {
        return self::getClass()->getMedalsForPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取勋章详情
     *
     * @param  int $medalId 勋章ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getInfo (int $medalId) {
        return self::getClass()->getInfo([
            "medalId" => $medalId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MemberMedal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MemberMedal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}