<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getConsumeRecordsByParams(array $params)
 * @method getUserConsumeRecordByOrderIdByParams(array $params)
 */
class ConsumeRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户消费记录-分页
     *
     * @support  int $userId 用户id 
     * @support  string $type 流水类型 
     * @support  array $types 多流水类型 
     * @support  int $orderId 订单ID [Original type uint] 
     * @support  array $sources 多平台 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getConsumeRecords (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getConsumeRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 通过OrderId获取用户消费记录
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  int $orderId 订单ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getUserConsumeRecordByOrderId (int $userId, int $orderId) {
        return self::getClass()->getUserConsumeRecordByOrderId([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'ConsumeRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'ConsumeRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}