<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getConsumeRecordsByParams(array $params)
 * @method listByParams(array $params)
 */
class ConsumeRecord {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取用户消费记录-分页
     *
     * @support  int $userId 用户id 
     * @support  string $type 流水类型 
     * @support  array $types 多流水类型 
     * @support  int $orderId 订单ID [Original type uint] 
     * @support  array $sources 多平台 
     * @support  string $source 平台 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getConsumeRecords (int $page = 1, int $pageSize = 15) {
        return self::getClass()->getConsumeRecords([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 获取用户消费记录
     *
     * @support  int $userId 用户ID 
     * @support  string $type 流水类型 
     * @support  array $types 多流水类型 
     * @support  int $orderId 订单ID [Original type uint] 
     * @support  string $source 平台 
     * @support  array $sources 多平台 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'ConsumeRecord');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'ConsumeRecord');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}