<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showPicFinishOrderByParams(array $params)
 * @method updateLastSpendEventByParams(array $params)
 * @method memberExpeditedWelfareByParams(array $params)
 * @method sendOrderRelatedMedalsByParams(array $params)
 * @method withdrawMedalsByParams(array $params)
 * @method userInvitationByParams(array $params)
 * @method userShowSelectionByParams(array $params)
 * @method userPerfectInformationByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽订单完成
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showPicFinishOrder (int $user_id) {
        return self::getClass()->showPicFinishOrder([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 蓝标、金标、kids、缦图摄影订单完成
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $source 类型 [ require true ]
     * @param  string $type 流水类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateLastSpendEvent (int $userId, string $source, string $type) {
        return self::getClass()->updateLastSpendEvent([
            "userId" => $userId,
            "source" => $source,
            "type" => $type,
        ]);
    }

    /**
     * 会员加急权益【降级做等级权益处理(减少)，升级保持权益】
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $change 等级变更类型 [ require true ]
     * @param  string $currentLevel 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberExpeditedWelfare (int $userId, string $change, string $currentLevel) {
        return self::getClass()->memberExpeditedWelfare([
            "userId" => $userId,
            "change" => $change,
            "currentLevel" => $currentLevel,
        ]);
    }

    /**
     * 完成订单服务
     *
     * @support  int $orderId 订单ID [Original type uint] [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @support  array $orderSkuList 产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendOrderRelatedMedals () {
        return self::getClass()->sendOrderRelatedMedals();
    }

    /**
     * 全款退款订单
     *
     * @support  int $orderId 订单内容 [Original type uint] [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function withdrawMedals () {
        return self::getClass()->withdrawMedals();
    }

    /**
     * 邀请用户-勋章处理
     *
     * @param  int $userId 邀请人用户ID [Original type uint] [ require true ]
     * @param  int $inviteNum 邀请数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userInvitation (int $userId, int $inviteNum) {
        return self::getClass()->userInvitation([
            "userId" => $userId,
            "inviteNum" => $inviteNum,
        ]);
    }

    /**
     * 邀请用户-勋章处理
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  int $setStarNum 精选数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userShowSelection (int $userId, int $setStarNum) {
        return self::getClass()->userShowSelection([
            "userId" => $userId,
            "setStarNum" => $setStarNum,
        ]);
    }

    /**
     * 完善用户信息-勋章处理
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function userPerfectInformation (int $userId) {
        return self::getClass()->userPerfectInformation([
            "userId" => $userId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}