<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method showPicFinishOrderByParams(array $params)
 * @method himoFinishOrderByParams(array $params)
 * @method memberExpeditedWelfareByParams(array $params)
 * @method sendMedalsByParams(array $params)
 * @method withdrawMedalsByParams(array $params)
 */
class Message {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽订单完成
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function showPicFinishOrder (int $user_id) {
        return self::getClass()->showPicFinishOrder([
            "user_id" => $user_id,
        ]);
    }

    /**
     * 蓝标、金标、kids、缦图摄影订单完成
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $source 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function himoFinishOrder (int $userId, string $source) {
        return self::getClass()->himoFinishOrder([
            "userId" => $userId,
            "source" => $source,
        ]);
    }

    /**
     * 会员加急权益【降级做等级权益处理(减少)，升级保持权益】
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $change 等级变更类型 [ require true ]
     * @param  string $currentLevel 类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function memberExpeditedWelfare (int $userId, string $change, string $currentLevel) {
        return self::getClass()->memberExpeditedWelfare([
            "userId" => $userId,
            "change" => $change,
            "currentLevel" => $currentLevel,
        ]);
    }

    /**
     * 完成订单服务
     *
     * @support  int $orderId 订单ID [Original type uint] [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @support  array $orderSkuList 产品信息 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function sendMedals () {
        return self::getClass()->sendMedals();
    }

    /**
     * 全款退款订单
     *
     * @support  int $orderId 订单内容 [Original type uint] [ require true ]
     * @support  array $orderBaseInfo 订单内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function withdrawMedals () {
        return self::getClass()->withdrawMedals();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Message');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Message');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}