<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getSeriesByParams(array $params)
 * @method getSeriesForPageByParams(array $params)
 */
class MedalSeries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建系列
     *
     * @param  string $name 系列名称 [ require true ]
     * @param  int $sort 排序 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, int $sort = 0) {
        return self::getClass()->create([
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 更新
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @support  string $name 系列名称 
     * @support  int $sort 排序 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 上线
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * 下线
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 系列查询
     *
     * @support  string $name 系列名称 
     * @support  string $status 系列状态 
     * @support  bool $withDel 包含软删除 
     * @support  array $sortBy 排序字段 
     * @throws  \Exception
     * @return  mixed
     */
    public static function getSeries () {
        return self::getClass()->getSeries();
    }

    /**
     * 系列查询分页
     *
     * @support  string $name 系列名称 
     * @support  string $status 系列状态 
     * @support  bool $withDel 包含软删除 
     * @support  array $sortBy 排序字段 
     * @param  int $page 分页 [Original type uint] [ require true ]
     * @param  int $pageSize 每页数量 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getSeriesForPage (int $page, int $pageSize) {
        return self::getClass()->getSeriesForPage([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}