<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method offlineByParams(array $params)
 * @method onlineByParams(array $params)
 */
class MedalSeries {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建系列
     *
     * @param  string $name 系列名称 [ require true ]
     * @param  int $sort 排序 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create (string $name, int $sort = 0) {
        return self::getClass()->create([
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 更新
     *
     * @support  int $id 系列ID [Original type uint] [ require true ]
     * @param  string $name 系列名称 [ require true ]
     * @param  int $sort 排序 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (string $name, int $sort = 0) {
        return self::getClass()->update([
            "name" => $name,
            "sort" => $sort,
        ]);
    }

    /**
     * 删除
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $id) {
        return self::getClass()->delete([
            "id" => $id,
        ]);
    }

    /**
     * 下线
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $id) {
        return self::getClass()->offline([
            "id" => $id,
        ]);
    }

    /**
     * 上线
     *
     * @param  int $id 系列ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $id) {
        return self::getClass()->online([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MedalSeries');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}