<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method deleteByParams(array $params)
 * @method onlineByParams(array $params)
 * @method offlineByParams(array $params)
 * @method getUserMedalsByParams(array $params)
 * @method receiveMedalByParams(array $params)
 */
class MemberMedal {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建勋章
     *
     * @support  string $name 勋章名称 [ require true ]
     * @support  string $type 勋章类型 
     * @support  int $rank 勋章等级 [Original type uint] [ require true ]
     * @support  int $sort 排序 [Original type uint] 
     * @support  int $seriesId 系列名称 [Original type uint] [ require true ]
     * @support  int $parentId 父级勋章ID [Original type uint] 
     * @support  array $content 勋章内容 
     * @support  string $relatedType 关联类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 修改勋章
     *
     * @param  int $medalId 勋章ID [Original type uint] [ require true ]
     * @support  string $name 勋章名称 [ require true ]
     * @support  int $rank 勋章等级 [Original type uint] [ require true ]
     * @support  int $seriesId 系列名称 [Original type uint] [ require true ]
     * @support  int $parentId 父级勋章ID [Original type uint] 
     * @support  array $content 内容 
     * @support  int $sort 排序 [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $medalId) {
        return self::getClass()->update([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 删除勋章
     *
     * @param  int $medalId 勋章ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function delete (int $medalId) {
        return self::getClass()->delete([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 上线勋章
     *
     * @param  int $medalId 勋章ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function online (int $medalId) {
        return self::getClass()->online([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 下线勋章
     *
     * @param  int $medalId 勋章ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function offline (int $medalId) {
        return self::getClass()->offline([
            "medalId" => $medalId,
        ]);
    }

    /**
     * 获取用户勋章
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserMedals (int $userId) {
        return self::getClass()->getUserMedals([
            "userId" => $userId,
        ]);
    }

    /**
     * 领取勋章
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  int $medalId 勋章ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receiveMedal (int $userId, int $medalId) {
        return self::getClass()->receiveMedal([
            "userId" => $userId,
            "medalId" => $medalId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MemberMedal');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MemberMedal');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}