<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createByParams(array $params)
 * @method updateByParams(array $params)
 * @method getAllMilestonesByParams(array $params)
 */
class Milestone {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建里程碑
     *
     * @support  string $name 名称 [ require true ]
     * @support  int $sort 排序 [Original type uint] [ require true ]
     * @support  int $integral 积分 [Original type uint] [ require true ]
     * @support  array $rewardContent 奖励内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function create () {
        return self::getClass()->create();
    }

    /**
     * 更新里程碑
     *
     * @param  int $id 里程碑ID [Original type uint] [ require true ]
     * @support  string $name 名称 
     * @support  int $sort 排序 [Original type uint] 
     * @support  int $integral 积分 [Original type uint] 
     * @support  array $rewardContent 奖励内容 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * 获取所有里程碑
     *
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllMilestones () {
        return self::getClass()->getAllMilestones();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\Milestone');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\Milestone');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}