<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method receivePointsByParams(array $params)
 * @method getPointsByParams(array $params)
 * @method listByParams(array $params)
 */
class Points {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 领取积分
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @support  int $outId 活动ID [Original type uint] [ require true ]
     * @support  int $points 积分 [Original type uint] [ require true ]
     * @support  string $type 积分类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function receivePoints (int $userId) {
        return self::getClass()->receivePoints([
            "userId" => $userId,
        ]);
    }

    /**
     * 积分变更查询-分页
     *
     * @support  array $types 类型s 
     * @support  int $outId 外部关联ID [Original type uint] 
     * @support  int $userId 用户Id [Original type uint] 
     * @support  array $userIds 用户Ids [Original type array&lt;uint&gt;] 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 每页条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getPoints (int $page, int $pageSize) {
        return self::getClass()->getPoints([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 积分变更查询-不分页
     *
     * @support  int $userId 用户Id [Original type uint] 
     * @support  array $types 类型 
     * @support  string $type 类型s 
     * @support  int $outId 外部关联ID [Original type uint] 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\Points');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\Points');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}