<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createOrderFlowByParams(array $params)
 * @method calcLevelByParams(array $params)
 * @method getUserUpgradeTargetByParams(array $params)
 * @method getMembersByParams(array $params)
 * @method getMemberInfoByParams(array $params)
 * @method listByParams(array $params)
 * @method updateByParams(array $params)
 */
class HimoMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建用户流水
     *
     * @support  string $type 流水类型 [ require true ]
     * @support  string $source 订单来源 [ require true ]
     * @support  float $money 金额 [Original type double] [ require true ]
     * @support  int $userId 用户uid [Original type uint] [ require true ]
     * @support  int $diffId 扩展ID [Original type uint] 
     * @support  int $orderId 订单id [Original type uint] [ require true ]
     * @support  bool $isRefundOver 部分退款是否退完 
     * @throws  \Exception
     * @return  mixed
     */
    public static function createOrderFlow () {
        return self::getClass()->createOrderFlow();
    }

    /**
     * 通过积分或消费次数的计算等级
     *
     * @param  int $integral 积分 [Original type uint] [ require true ]
     * @param  int $consumeNum 消费次数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function calcLevel (int $integral, int $consumeNum) {
        return self::getClass()->calcLevel([
            "integral" => $integral,
            "consumeNum" => $consumeNum,
        ]);
    }

    /**
     * 查询用户升级目标
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserUpgradeTarget (int $userId) {
        return self::getClass()->getUserUpgradeTarget([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员列表-分页
     *
     * @support  array $userIds 用户ids [Original type array&lt;uint&gt;] 
     * @support  array $levels 会员等级 
     * @support  array $consumeNumExp 消费次数表达式 
     * @support  string $birthStart 生日筛选 
     * @support  string $birthEnd 生日筛选 
     * @support  string $lastBuyTime 最后购买时间 
     * @support  string $lastBuyTimeStart  最后消费时间-开始 
     * @support  string $lastBuyTimeEnd  最后消费时间-结束 
     * @support  array $sortBy 排序字段 
     * @param  int $page 页码 [ require true ]
     * @param  int $pageSize 条数 [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMembers (int $page, int $pageSize) {
        return self::getClass()->getMembers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * 会员详情
     *
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getMemberInfo (int $userId) {
        return self::getClass()->getMemberInfo([
            "userId" => $userId,
        ]);
    }

    /**
     * 获取会员列表
     *
     * @support  array $userIds 用户ids [Original type array&lt;uint&gt;] 
     * @support  array $levels 会员等级 
     * @support  array $consumeNumExp 消费次数表达式 
     * @support  string $birthStart 生日筛选 
     * @support  string $birthEnd 生日筛选 
     * @support  string $lastBuyTime 最后购买时间 
     * @support  string $lastBuyTimeStart  最后消费时间-开始 
     * @support  string $lastBuyTimeEnd  最后消费时间-结束 
     * @support  array $sortBy 排序字段 
     * @throws  \Exception
     * @return  mixed
     */
    public static function list () {
        return self::getClass()->list();
    }

    /**
     * 修改会员相关信息
     *
     * @param  int $id 会员ID [ require true ]
     * @support  string $birthYear 用户生日年份 
     * @support  string $birthDate 会员生日 月日 
     * @throws  \Exception
     * @return  mixed
     */
    public static function update (int $id) {
        return self::getClass()->update([
            "id" => $id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}