<?php
namespace Mainto\Bridge\Invokes\UserMember\ShowPic;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method updateConsumeRecordByParams(array $params)
 * @method infoByParams(array $params)
 * @method queryShowPicMembersByParams(array $params)
 */
class ShowPicMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 更新消费信息
     *
     * @support  int $userId 用户ID [Original type uint] [ require true ]
     * @support  float $money 消费金额 [Original type double] [ require true ]
     * @support  int $orderId 消费订单ID [Original type uint] [ require true ]
     * @support  string $type 消费类型 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateConsumeRecord () {
        return self::getClass()->updateConsumeRecord();
    }

    /**
     * 获取用户消费详情
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function info (int $userId) {
        return self::getClass()->info([
            "userId" => $userId,
        ]);
    }

    /**
     * 修修兽会员列表查询分页
     *
     * @support  string $createdAtStart 使用时间起 
     * @support  string $createdAtEnd 使用时间止 
     * @support  array $userIds 用户IDs [Original type array&lt;uint&gt;] 
     * @support  string $orderColumn 排序列 
     * @support  string $orderDirect 排序方向 
     * @support  string $source 来源 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $pageSize 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryShowPicMembers (int $page, int $pageSize) {
        return self::getClass()->queryShowPicMembers([
            "page" => $page,
            "pageSize" => $pageSize,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'ShowPic\ShowPicMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'ShowPic\ShowPicMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}