<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAllWelfareByParams(array $params)
 * @method addWelfareByParams(array $params)
 * @method editWelfareByParams(array $params)
 */
class MemberWelfare {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 查询所有会员权益
     *
     * @param  bool $sortDesc 排序倒叙 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function getAllWelfare (bool $sortDesc = false) {
        return self::getClass()->getAllWelfare([
            "sortDesc" => $sortDesc,
        ]);
    }

    /**
     * 增加权益规则
     *
     * @param  string $welfareName 权益名称 [ require true ]
     * @param  array $welfareIcon 权益图片 [ require true ]
     * @param  string $welfareNote 权益备注 [ require true ]
     * @param  array $memberLevel 所属等级 [ require true ]
     * @param  int $sort 排序 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function addWelfare (string $welfareName, array $welfareIcon, string $welfareNote, array $memberLevel, int $sort) {
        return self::getClass()->addWelfare([
            "welfareName" => $welfareName,
            "welfareIcon" => $welfareIcon,
            "welfareNote" => $welfareNote,
            "memberLevel" => $memberLevel,
            "sort" => $sort,
        ]);
    }

    /**
     * 修改权益
     *
     * @param  int $welfareId 规则id [ require true ]
     * @support  string $welfareName 权益名称 
     * @support  array $welfareIcon 权益图片 
     * @support  string $welfareNote 权益备注 
     * @support  array $memberLevel 所属等级 
     * @support  int $sort 排序 
     * @throws  \Exception
     * @return  mixed
     */
    public static function editWelfare (int $welfareId) {
        return self::getClass()->editWelfare([
            "welfareId" => $welfareId,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\MemberWelfare');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\MemberWelfare');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}