<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method saveMemberInfoByRegisterByParams(array $params)
 * @method saveMemberInfoByConsumeByParams(array $params)
 */
class Common {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 保存用户会员信息[注册]-修修兽
     *
     * @support  int $user_id 用户ID [Original type uint] [ require true ]
     * @support  string $tag_content 标记内容 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveMemberInfoByRegister () {
        return self::getClass()->saveMemberInfoByRegister();
    }

    /**
     * 保存用户会员信息【消费】- 修修兽
     *
     * @param  int $userId 用户ID [Original type uint] [ require true ]
     * @param  string $source 来源 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function saveMemberInfoByConsume (int $userId, string $source) {
        return self::getClass()->saveMemberInfoByConsume([
            "userId" => $userId,
            "source" => $source,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Common');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Common');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}