<?php
namespace Mainto\Bridge\Invokes\UserMember\Himo;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method createConsumeRecordByParams(array $params)
 * @method getUserLevelByParams(array $params)
 * @method unbindOrderByParams(array $params)
 * @method bindOrderByParams(array $params)
 * @method fixScoreByParams(array $params)
 * @method getUserUpgradeTargetByParams(array $params)
 * @method calcMemberForOneByParams(array $params)
 */
class HimoMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 创建用户流水
     *
     * @param  string $type 流水类型 [ require true ]
     * @param  float $money 金额 [Original type double] [ require true ]
     * @param  int $userId 用户uid [Original type uint] [ require true ]
     * @param  int $diffId 扩展ID [Original type uint] [ require true ]
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function createConsumeRecord (int $userId, string $type, float $money, int $diffId, int $orderId) {
        return self::getClass()->createConsumeRecord([
            "userId" => $userId,
            "type" => $type,
            "money" => $money,
            "diffId" => $diffId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 获取当前用户的等级
     *
     * @param  int $integral 积分 [Original type uint] [ require true ]
     * @param  int $consumeNum 消费次数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getUserLevel (int $integral, int $consumeNum) {
        return self::getClass()->getUserLevel([
            "integral" => $integral,
            "consumeNum" => $consumeNum,
        ]);
    }

    /**
     * 解绑订单
     *
     * @param  int $orderId 订单id [Original type uint] [ require true ]
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function unbindOrder (int $userId, int $orderId) {
        return self::getClass()->unbindOrder([
            "userId" => $userId,
            "orderId" => $orderId,
        ]);
    }

    /**
     * 绑定订单
     *
     * @param  array $refunds 退款流水 [ require true ]
     * @param  int $userId 用户id [Original type uint] [ require true ]
     * @param  array $orderInfo 订单 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function bindOrder (int $userId, array $orderInfo, array $refunds = []) {
        return self::getClass()->bindOrder([
            "userId" => $userId,
            "orderInfo" => $orderInfo,
            "refunds" => $refunds,
        ]);
    }

    /**
     * 用户积分修正
     *
     * @support  int $score 用户增加/减少积分 [ require true ]
     * @support  int $userId 用户id [ require true ]
     * @support  int $consumeNum 用户消费次数 
     * @throws  \Exception
     * @return  mixed
     */
    public static function fixScore () {
        return self::getClass()->fixScore();
    }

    /**
     * 查询用户升级目标
     *
     * @param  int $userId 用户id [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function getUserUpgradeTarget (int $userId) {
        return self::getClass()->getUserUpgradeTarget([
            "userId" => $userId,
        ]);
    }

    /**
     * 测试用 年审某个用户会员
     *
     * @param  int $user_id 用户uid [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function calcMemberForOne (int $user_id) {
        return self::getClass()->calcMemberForOne([
            "user_id" => $user_id,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'Himo\HimoMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}