<?php
namespace Mainto\Bridge\Invokes\UserMember;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Unique
 * @method queryShowPicMembersByParams(array $params)
 * @method updateConsumeRecordByParams(array $params)
 */
class ShowPicMember {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 修修兽会员列表查询分页
     *
     * @support  string $created_at_start 使用时间起 
     * @support  string $created_at_end 使用时间止 
     * @support  array $user_ids 用户IDs [Original type array&lt;uint&gt;] 
     * @support  string $order_column 排序列 
     * @support  string $order_direct 排序方向 
     * @param  int $page 页码 [Original type uint] [ require true ]
     * @param  int $page_size 每页条数 [Original type uint] [ require true ]
     * @throws  \Exception
     * @return  array
     */
    public static function queryShowPicMembers (int $page, int $page_size) {
        return self::getClass()->queryShowPicMembers([
            "page" => $page,
            "page_size" => $page_size,
        ]);
    }

    /**
     * 更新消费信息
     *
     * @param  int $user_id 用户ID [Original type uint] [ require true ]
     * @param  float $consume_amount 消费金额 [Original type unsignedDouble] [ require true ]
     * @param  string $order_no 订单号 [ require true ]
     * @param  string $source 订单号 [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function updateConsumeRecord (int $user_id, float $consume_amount, string $order_no, string $source) {
        return self::getClass()->updateConsumeRecord([
            "user_id" => $user_id,
            "consume_amount" => $consume_amount,
            "order_no" => $order_no,
            "source" => $source,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserMember', 'ShowPicMember');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserMember', 'ShowPicMember');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}