<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-04 17:03:40
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Wx
 * @method getJssdkByParams(array $params) 微信获取jssdk配置
 * @method getApiTicketByParams(array $params) 获取api ticket
 * @method getAccessTokenByParams(array $params) 获取accessToken
 * @method getWxCardExtFieldByParams(array $params) 生成微信卡券CardExt
 * @method receiveCardLogByParams(array $params) 领取记录
 * @method consumeWxCardCodeByParams(array $params) 核销微信卡券code
 * @method decryptWxCardCodeByParams(array $params) 解密微信卡券Code
 * @method sendTemplateMsgByParams(array $params) 发送模板消息
 * @method sendTemplateMsgByWxAppByParams(array $params) 发送微信小程序模板消息
 * @method sendSubscribeMsgByWxAppByParams(array $params) 发送小程序订阅消息
 * @method sendKfMsgByParams(array $params) 发送微信客服消息 （仅支持字符串）
 * @method sendKfMsgAllTypeByParams(array $params) 发送微信客服消息 (支持所有格式)
 * @method checkWxCardCodeByParams(array $params) 获取微信卡券Code状态信息
 * @method getMaterialListByParams(array $params) 获取永久素材列表
 * @method getTempMaterialByParams(array $params) 获取临时素材
 * @method genQrcodeByParams(array $params) 生成二维码-永久
 * @method genTempQrCodeByParams(array $params) 生成临时二维码
 * @method checkUserSubscribeByParams(array $params) 检查用户是否关注公众号
 * @method batchGetUserSubscribeByParams(array $params) 批量获取用户信息
 * @method getUserListByParams(array $params) 获取用户列表
 * @method getWechatInfoByCodeByParams(array $params) 根据微信Code获取微信信息
 * @method uploadImageByParams(array $params) 上传永久素材图片
 * @method getWechatInfoByOpenIdByParams(array $params) 根据openid获取用户信息
 * @method asyncSendTemplateMsgByParams(array $params) 发送模板消息
 * @method createWxMiniCodeByParams(array $params) 作废-生成小程序码
 * @method generateWxMiniSchemeByParams(array $params) 作废-生成小程序scheme码
 * @method createUnlimitedWxMiniCodeByParams(array $params) 生成小程序码-无限制
 * @method generateWxMiniUrlLinkByParams(array $params) 生成小程序UrlLink
 * @method getMiniAccessTokenByParams(array $params) 获取小程序AccessToken
 * @method getStableMiniAccessTokenByParams(array $params) 获取小程序AccessToken-稳定版
 * @method updateOfficialAccountMenuByParams(array $params) 更新微信公众号菜单
 */
class Wx {
    private static string $serviceName = "UserAuth";

    private static string $className = "Wx";

    /**
     * 微信获取jssdk配置
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getJssdk (string $scene, string $url, bool $debug = false) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getJssdk(["scene" => $scene, "url" => $url, "debug" => $debug]);
    }

    /**
     * 获取api ticket
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getApiTicket (string $scene) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getApiTicket(["scene" => $scene]);
    }

    /**
     * 获取accessToken
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAccessToken (string $scene, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAccessToken(array_merge($_params, ["scene" => $scene]));
    }

    /**
     * 生成微信卡券CardExt
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getWxCardExtField (string $scene, string $code = '', string $openid = '', string $card_id = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWxCardExtField(["scene" => $scene, "code" => $code, "openid" => $openid, "card_id" => $card_id]);
    }

    /**
     * 领取记录
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function receiveCardLog (string $brand, int $himoid, string $code, string $card_id, string $openid = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->receiveCardLog(["brand" => $brand, "himoid" => $himoid, "code" => $code, "card_id" => $card_id, "openid" => $openid]);
    }

    /**
     * 核销微信卡券code
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function consumeWxCardCode (string $scene, string $code, string $cardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->consumeWxCardCode(["scene" => $scene, "code" => $code, "cardId" => $cardId]);
    }

    /**
     * 解密微信卡券Code
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function decryptWxCardCode (string $scene, string $encryptCode) {
        return RpcClass::getClass(self::$serviceName, self::$className)->decryptWxCardCode(["scene" => $scene, "encryptCode" => $encryptCode]);
    }

    /**
     * 发送模板消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendTemplateMsg (int $type, string $id, string $app_name, string $template_id, array $data = [], string $url = '', array $miniProgram = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendTemplateMsg(["type" => $type, "id" => $id, "app_name" => $app_name, "template_id" => $template_id, "data" => $data, "url" => $url, "miniProgram" => $miniProgram]);
    }

    /**
     * 发送微信小程序模板消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendTemplateMsgByWxApp (string $id, string $app_name, string $template_id, string $form_id, array $data = [], string $page = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendTemplateMsgByWxApp(["id" => $id, "app_name" => $app_name, "template_id" => $template_id, "form_id" => $form_id, "data" => $data, "page" => $page]);
    }

    /**
     * 发送小程序订阅消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendSubscribeMsgByWxApp (int $type, string $id, string $app_name, string $template_id, array $data = [], string $miniprogram_state = '', string $page = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendSubscribeMsgByWxApp(["type" => $type, "id" => $id, "app_name" => $app_name, "template_id" => $template_id, "data" => $data, "miniprogram_state" => $miniprogram_state, "page" => $page]);
    }

    /**
     * 发送微信客服消息 （仅支持字符串）
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendKfMsg (int $type, string $id, string $app_name, string $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKfMsg(["type" => $type, "id" => $id, "app_name" => $app_name, "content" => $content]);
    }

    /**
     * 发送微信客服消息 (支持所有格式)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function sendKfMsgAllType (int $type, string $id, string $app_name, array $content, int $msgType = 1) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendKfMsgAllType(["type" => $type, "id" => $id, "app_name" => $app_name, "content" => $content, "msgType" => $msgType]);
    }

    /**
     * 获取微信卡券Code状态信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function checkWxCardCode (string $scene, string $code, string $cardId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCardCode(["scene" => $scene, "code" => $code, "cardId" => $cardId]);
    }

    /**
     * 获取永久素材列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getMaterialList (string $app_name, string $type, int $offset = 0, int $count = 20) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMaterialList(["app_name" => $app_name, "type" => $type, "offset" => $offset, "count" => $count]);
    }

    /**
     * 获取临时素材
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getTempMaterial (string $appName, string $mediaId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTempMaterial(["appName" => $appName, "mediaId" => $mediaId]);
    }

    /**
     * 生成二维码-永久
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function genQrcode (string $app_name, string $key = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->genQrcode(["app_name" => $app_name, "key" => $key]);
    }

    /**
     * 生成临时二维码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function genTempQrCode (string $appName, string $key, int $expireSeconds = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->genTempQrCode(["appName" => $appName, "key" => $key, "expireSeconds" => $expireSeconds]);
    }

    /**
     * 检查用户是否关注公众号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function checkUserSubscribe (string $app_name, string $open_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkUserSubscribe(["app_name" => $app_name, "open_id" => $open_id]);
    }

    /**
     * 批量获取用户信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function batchGetUserSubscribe (string $appName, array $openIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->batchGetUserSubscribe(["appName" => $appName, "openIds" => $openIds]);
    }

    /**
     * 获取用户列表
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getUserList (string $appName, string $nextOpenId = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserList(["appName" => $appName, "nextOpenId" => $nextOpenId]);
    }

    /**
     * 根据微信Code获取微信信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getWechatInfoByCode (string $app_name, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWechatInfoByCode(["app_name" => $app_name, "code" => $code]);
    }

    /**
     * 上传永久素材图片
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function uploadImage (string $img_path, string $app_name) {
        return RpcClass::getClass(self::$serviceName, self::$className)->uploadImage(["img_path" => $img_path, "app_name" => $app_name]);
    }

    /**
     * 根据openid获取用户信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getWechatInfoByOpenId (string $app_name, string $open_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getWechatInfoByOpenId(["app_name" => $app_name, "open_id" => $open_id]);
    }

    /**
     * 发送模板消息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function asyncSendTemplateMsg (\Mainto\Bridge\Structs\UserAuth\Wx\AsyncSendTemplateMsgParamsContent $content) {
        return RpcClass::getClass(self::$serviceName, self::$className)->asyncSendTemplateMsg(["content" => $content]);
    }

    /**
     * 作废-生成小程序码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createWxMiniCode (string $appName, string $path, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createWxMiniCode(array_merge($_params, ["appName" => $appName, "path" => $path]));
    }

    /**
     * 作废-生成小程序scheme码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function generateWxMiniScheme (string $appName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->generateWxMiniScheme(array_merge($_params, ["appName" => $appName]));
    }

    /**
     * 生成小程序码-无限制
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function createUnlimitedWxMiniCode (string $appName, string $scene, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createUnlimitedWxMiniCode(array_merge($_params, ["appName" => $appName, "scene" => $scene]));
    }

    /**
     * 生成小程序UrlLink
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function generateWxMiniUrlLink (string $appName, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->generateWxMiniUrlLink(array_merge($_params, ["appName" => $appName]));
    }

    /**
     * 获取小程序AccessToken
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getMiniAccessToken (string $appName, bool $refresh = false, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getMiniAccessToken(array_merge($_params, ["appName" => $appName, "refresh" => $refresh]));
    }

    /**
     * 获取小程序AccessToken-稳定版
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getStableMiniAccessToken (string $appName) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getStableMiniAccessToken(["appName" => $appName]);
    }

    /**
     * 更新微信公众号菜单
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function updateOfficialAccountMenu (string $liveDiscountPage, string $password, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateOfficialAccountMenu(array_merge($_params, ["liveDiscountPage" => $liveDiscountPage, "password" => $password]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}