<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-04 19:02:53
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Auth
 * @method loginByPassByParams(array $params) 通过用户名&amp;密码登录
 * @method loginByPwdByParams(array $params) 通过用户名&amp;密码登录 校验token
 * @method wxLoginByPhoneByParams(array $params) 微信公众号登录-手机验证码
 * @method getTokenByTempByParams(array $params) 通过临时token换取token
 * @method getTempTokenByCodeByParams(array $params) 通过小程序code换取temp_token
 * @method loginByTokenByParams(array $params) 通过token登陆
 * @method getOpenIdByTokenByParams(array $params) 根据token获取openid
 * @method bindOAuthIdByParams(array $params) 绑定第三方OAuth用户标示
 * @method logoutByParams(array $params) 退出登录
 * @method getAuthInfoByIdByParams(array $params) 根据登录ID获取权限(此接口用于网关获取登录状态)
 * @method getAuthExpireTimeByParams(array $params) 获取当前session过期时间
 * @method getUserPermissionByParams(array $params) 获取当前用户权限
 * @method wxAppLoginByEncryptedCodeByParams(array $params) 微信小程序登录-使用加密数据 - 接口安全版
 * @method wxAppLoginByEncryptedByParams(array $params) 微信小程序登录-使用加密数据
 * @method bindUserWechatByCodeByParams(array $params) 根据code绑定品牌用户
 * @method bindUserWxInfoByCodeByParams(array $params) 根据code绑定品牌用户微信信息
 * @method loginByOpenIdByParams(array $params) 微信三方登录-海马体app
 * @method loginByAppleTokenByParams(array $params) 苹果账户三方登录
 * @method getTokenFromAppByParams(array $params) app端获取token
 * @method getUserDeviceByUserIdByParams(array $params) 通过userId获取友盟设备号
 * @method getOpenIdByCodeByParams(array $params) 通过小程序code获取openID
 * @method code2SessionByCodeByParams(array $params) 通过小程序code获取openID和unionID
 * @method alipayMiniLoginByEncryptedByParams(array $params) 支付宝小程序登录-使用加密数据
 * @method loginByCodeByAlipayMiniByParams(array $params) 通过支付宝小程序code登录
 * @method getAlipayUserIdByCodeByParams(array $params) 通过支付宝小程序code获取userId
 * @method sendSmsWithTempTokenByParams(array $params) 发送短信并校验鉴权temp-token
 * @method bindWechatByParams(array $params) 绑定微信
 * @method removeUserAuthBindInfoByParams(array $params) 移除用户绑定信息
 * @method userAuthBindInfoByParams(array $params) 用户当前绑定信息
 * @method checkLoginEventByParams(array $params) java验证loginEvent
 * @method getByThirdIdentifyIdsByParams(array $params) 根据openids获取信息
 */
class Auth {
    private static string $serviceName = "UserAuth";

    private static string $className = "Auth";

    /**
     * 通过用户名&amp;密码登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByPass (string $phone, string $pass, string $temp_token = '', string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPass(array_merge($_params, ["phone" => $phone, "pass" => $pass, "temp_token" => $temp_token, "brand" => $brand]));
    }

    /**
     * 通过用户名&amp;密码登录 校验token
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByPwd (string $phone, string $pass, string $token, string $tokenType, string $tempToken = '', string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPwd(array_merge($_params, ["phone" => $phone, "pass" => $pass, "token" => $token, "tokenType" => $tokenType, "tempToken" => $tempToken, "brand" => $brand]));
    }

    /**
     * 微信公众号登录-手机验证码
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function wxLoginByPhone (string $brand, string $phone, string $caption, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wxLoginByPhone(array_merge($_params, ["brand" => $brand, "phone" => $phone, "caption" => $caption]));
    }

    /**
     * 通过临时token换取token
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getTokenByTemp (string $brand, string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTokenByTemp(["brand" => $brand, "temp_token" => $temp_token]);
    }

    /**
     * 通过小程序code换取temp_token
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getTempTokenByCode (string $brand, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTempTokenByCode(["brand" => $brand, "code" => $code]);
    }

    /**
     * 通过token登陆
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByToken (string $token, string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByToken(array_merge($_params, ["token" => $token, "brand" => $brand]));
    }

    /**
     * 根据token获取openid
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getOpenIdByToken (string $token, string $brand = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOpenIdByToken(["token" => $token, "brand" => $brand]);
    }

    /**
     * 绑定第三方OAuth用户标示
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function bindOAuthId (int $type, string $openId, string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindOAuthId(array_merge($_params, ["type" => $type, "openId" => $openId, "brand" => $brand]));
    }

    /**
     * 退出登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function logout (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logout(array_merge($_params, []));
    }

    /**
     * 根据登录ID获取权限(此接口用于网关获取登录状态)
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAuthInfoById (string $auth_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthInfoById(["auth_id" => $auth_id]);
    }

    /**
     * 获取当前session过期时间
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAuthExpireTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthExpireTime();
    }

    /**
     * 获取当前用户权限
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getUserPermission (string $prefix = '', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserPermission(array_merge($_params, ["prefix" => $prefix]));
    }

    /**
     * 微信小程序登录-使用加密数据 - 接口安全版
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function wxAppLoginByEncryptedCode (string $brand, string $code, string $temp_token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wxAppLoginByEncryptedCode(array_merge($_params, ["brand" => $brand, "code" => $code, "temp_token" => $temp_token]));
    }

    /**
     * 微信小程序登录-使用加密数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function wxAppLoginByEncrypted (string $brand, string $mobile_encrypt, string $mobile_iv, string $temp_token, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wxAppLoginByEncrypted(array_merge($_params, ["brand" => $brand, "mobile_encrypt" => $mobile_encrypt, "mobile_iv" => $mobile_iv, "temp_token" => $temp_token]));
    }

    /**
     * 根据code绑定品牌用户
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function bindUserWechatByCode (string $code, string $brand, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserWechatByCode(["code" => $code, "brand" => $brand, "userId" => $userId]);
    }

    /**
     * 根据code绑定品牌用户微信信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function bindUserWxInfoByCode (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserWxInfoByCode(array_merge($_params, []));
    }

    /**
     * 微信三方登录-海马体app
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByOpenId (string $brand = 'mantu_app', string $openId, string $accessToken, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByOpenId(array_merge($_params, ["brand" => $brand, "openId" => $openId, "accessToken" => $accessToken]));
    }

    /**
     * 苹果账户三方登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByAppleToken (string $identityToken, string $brand = 'mantu_app', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByAppleToken(array_merge($_params, ["identityToken" => $identityToken, "brand" => $brand]));
    }

    /**
     * app端获取token
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  string
    */
    public static function getTokenFromApp (string $brand = 'mantu_app', string $deviceToken, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTokenFromApp(array_merge($_params, ["brand" => $brand, "deviceToken" => $deviceToken]));
    }

    /**
     * 通过userId获取友盟设备号
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getUserDeviceByUserId (int $userId, string $brand = 'mantu_app') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserDeviceByUserId(["userId" => $userId, "brand" => $brand]);
    }

    /**
     * 通过小程序code获取openID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function getOpenIdByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOpenIdByCode(["code" => $code, "brand" => $brand]);
    }

    /**
     * 通过小程序code获取openID和unionID
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function code2SessionByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->code2SessionByCode(["code" => $code, "brand" => $brand]);
    }

    /**
     * 支付宝小程序登录-使用加密数据
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function alipayMiniLoginByEncrypted (string $brand, string $decryptData, string $tempToken, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->alipayMiniLoginByEncrypted(array_merge($_params, ["brand" => $brand, "decryptData" => $decryptData, "tempToken" => $tempToken]));
    }

    /**
     * 通过支付宝小程序code登录
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function loginByCodeByAlipayMini (string $code, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByCodeByAlipayMini(array_merge($_params, ["code" => $code]));
    }

    /**
     * 通过支付宝小程序code获取userId
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function getAlipayUserIdByCode (string $code, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAlipayUserIdByCode(array_merge($_params, ["code" => $code]));
    }

    /**
     * 发送短信并校验鉴权temp-token
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function sendSmsWithTempToken (string $brand, string $phone, string $tempToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendSmsWithTempToken(["brand" => $brand, "phone" => $phone, "tempToken" => $tempToken]);
    }

    /**
     * 绑定微信
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function bindWechat (string $tempToken, string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindWechat(array_merge($_params, ["tempToken" => $tempToken, "brand" => $brand]));
    }

    /**
     * 移除用户绑定信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function removeUserAuthBindInfo (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeUserAuthBindInfo(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * 用户当前绑定信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  array
    */
    public static function userAuthBindInfo (string $brand, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAuthBindInfo(array_merge($_params, ["brand" => $brand]));
    }

    /**
     * java验证loginEvent
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  bool
    */
    public static function checkLoginEvent (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkLoginEvent(array_merge($_params, []));
    }

    /**
     * 根据openids获取信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getByThirdIdentifyIds (array $thirdIdentifyIds) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getByThirdIdentifyIds(["thirdIdentifyIds" => $thirdIdentifyIds]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}