<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2026-01-04 18:51:26
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class Channel
 * @method addByParams(array $params) 新增渠道
 * @method updateByParams(array $params) 更新渠道信息
 * @method deleteByParams(array $params) 删除渠道
 * @method listByParams(array $params) 渠道号列表
 * @method logsByParams(array $params) 获取渠道日志
 * @method logsCountByParams(array $params) 获取渠道日志计数
 * @method channelQrcodeByParams(array $params) 获取渠道二维码
 * @method getChannelLogsByParams(array $params) 获取关注列表-分页
 */
class Channel {
    private static string $serviceName = "UserAuth";

    private static string $className = "Channel";

    /**
     * 新增渠道
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function add (string $name, string $brand, int $channelNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["name" => $name, "brand" => $brand, "channelNum" => $channelNum]);
    }

    /**
     * 更新渠道信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function update (int $id, int $channelNum = 0, string $name = '', string $brand = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "channelNum" => $channelNum, "name" => $name, "brand" => $brand]);
    }

    /**
     * 删除渠道
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }

    /**
     * 渠道号列表
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function list (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(array_merge($_params, []));
    }

    /**
     * 获取渠道日志
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function logs (int $id, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logs(array_merge($_params, ["id" => $id]));
    }

    /**
     * 获取渠道日志计数
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function logsCount (array $ids, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logsCount(array_merge($_params, ["ids" => $ids]));
    }

    /**
     * 获取渠道二维码
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  string
    */
    public static function channelQrcode (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->channelQrcode(["id" => $id]);
    }

    /**
     * 获取关注列表-分页
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getChannelLogs (int $page = 1, int $pageSize = 10, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChannelLogs(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}