<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-29 18:09:18
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class WechatOAuth
 * @method getAuthUrlByParams(array $params) 获取微信认证跳转Url
 * @method authByCodeByParams(array $params) 通过Code获取微信用户信息
 * @method afterAuthGetUserInfoByParams(array $params) 登录后获取用户数据
 * @method createMemberCardByParams(array $params) 创建会员卡
 * @method updateMemberInfoByParams(array $params) 更新会员卡积分
 * @method checkWxCallbackForMantuHomeByParams(array $params) 微信校验回调地址-缦图之家
 * @method checkWxCallbackForMantuByParams(array $params) 微信校验回调地址-缦图
 * @method checkWxCallbackForHimoByParams(array $params) 微信校验回调地址-海马体
 * @method checkWxCallbackForKidsByParams(array $params) 微信校验回调地址-kids
 */
class WechatOAuth {
    private static string $serviceName = "UserAuth";

    private static string $className = "WechatOAuth";

    /**
     * 获取微信认证跳转Url
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAuthUrl (string $brand, string $url, string $scopes = 'snsapi_userinfo', array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthUrl(array_merge($_params, ["brand" => $brand, "url" => $url, "scopes" => $scopes]));
    }

    /**
     * 通过Code获取微信用户信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function authByCode (string $code, string $state, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->authByCode(array_merge($_params, ["code" => $code, "state" => $state]));
    }

    /**
     * 登录后获取用户数据
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function afterAuthGetUserInfo (string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterAuthGetUserInfo(["temp_token" => $temp_token]);
    }

    /**
     * 创建会员卡
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function createMemberCard (string $scene, array $cardInfo = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->createMemberCard(["scene" => $scene, "cardInfo" => $cardInfo]);
    }

    /**
     * 更新会员卡积分
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  bool
    */
    public static function updateMemberInfo (string $scene, string $cardId, string $cardCode, string $note, int $integral) {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMemberInfo(["scene" => $scene, "cardId" => $cardId, "cardCode" => $cardCode, "note" => $note, "integral" => $integral]);
    }

    /**
     * 微信校验回调地址-缦图之家
     * @return  string
    */
    public static function checkWxCallbackForMantuHome () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForMantuHome();
    }

    /**
     * 微信校验回调地址-缦图
     * @return  string
    */
    public static function checkWxCallbackForMantu () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForMantu();
    }

    /**
     * 微信校验回调地址-海马体
     * @return  string
    */
    public static function checkWxCallbackForHimo () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForHimo();
    }

    /**
     * 微信校验回调地址-kids
     * @return  string
    */
    public static function checkWxCallbackForKids () {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForKids();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}