<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2025-12-29 18:09:18
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use InvalidArgumentException;

/**
 * Class AuthBase
 * @method getAuthsByParams(array $params) 获取登录鉴权信息
 * @method getUserDevicesByParams(array $params) 获取app登录设备关联信息
 * @method getUserDeviceInfoByParams(array $params) 获取用户关联device信息
 * @method getAuthInfoByUserIdByParams(array $params) 获取用户鉴权信息
 * @method getAuthInfoByThirdIdentityIdByParams(array $params) 根据第三方证牌获取鉴权信息
 * @method getAuthListByParams(array $params) 分页获取登录鉴权信息
 */
class AuthBase {
    private static string $serviceName = "UserAuth";

    private static string $className = "AuthBase";

    /**
     * 获取登录鉴权信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAuths (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuths(array_merge($_params, []));
    }

    /**
     * 获取app登录设备关联信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUserDevices (array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserDevices(array_merge($_params, []));
    }

    /**
     * 获取用户关联device信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getUserDeviceInfo (string $brand, int $userId, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserDeviceInfo(array_merge($_params, ["brand" => $brand, "userId" => $userId]));
    }

    /**
     * 获取用户鉴权信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  array
    */
    public static function getAuthInfoByUserId (int $userId, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthInfoByUserId(["userId" => $userId, "brand" => $brand]);
    }

    /**
     * 根据第三方证牌获取鉴权信息
     * @deprecated  当前函数未使用 Object DTO 需谨慎使用
     * @return  mixed
    */
    public static function getAuthInfoByThirdIdentityId (string $thirdIdentityId, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthInfoByThirdIdentityId(["thirdIdentityId" => $thirdIdentityId, "brand" => $brand]);
    }

    /**
     * 分页获取登录鉴权信息
     * @deprecated  当前函数使用RpcParams方案，未使用CMD对象方案，建议使用ByParams方案
     * @return  mixed
    */
    public static function getAuthList (int $page = 1, int $pageSize = 20, array $_params = []) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthList(array_merge($_params, ["page" => $page, "pageSize" => $pageSize]));
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}