<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-07-07 11:41:01
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Channel
 */
class Channel {
    private static string $serviceName = "UserAuth";

    private static string $className = "Channel";

    /**
     * 新增渠道
     * @return  mixed
    */
    public static function add (string $name, string $brand, int $channelNum) {
        return RpcClass::getClass(self::$serviceName, self::$className)->add(["name" => $name, "brand" => $brand, "channelNum" => $channelNum]);
    }
    /**
     * 更新渠道信息
     * @return  mixed
    */
    public static function update (int $id, int $channelNum = 0, string $name = '', string $brand = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->update(["id" => $id, "channelNum" => $channelNum, "name" => $name, "brand" => $brand]);
    }
    /**
     * 删除渠道
     * @return  bool
    */
    public static function delete (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->delete(["id" => $id]);
    }
    /**
     * 渠道号列表
     * @return  mixed
    */
    public static function list (string $name, string $brand, int $channelNum, int $page, int $pageSize) {
        return RpcClass::getClass(self::$serviceName, self::$className)->list(["name" => $name, "brand" => $brand, "channelNum" => $channelNum, "page" => $page, "pageSize" => $pageSize]);
    }
    /**
     * 获取渠道日志
     * @return  mixed
    */
    public static function logs (int $id, bool $fromSubscribe) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logs(["id" => $id, "fromSubscribe" => $fromSubscribe]);
    }
    /**
     * 获取渠道日志计数
     * @return  mixed
    */
    public static function logsCount (array $ids) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logsCount(["ids" => $ids]);
    }
    /**
     * 获取渠道二维码
     * @return  string
    */
    public static function channelQrcode (int $id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->channelQrcode(["id" => $id]);
    }
    /**
     * 获取关注列表-分页
     * @return  mixed
    */
    public static function getChannelLogs (int $page = 1, int $pageSize = 10, int $channelId, array $channelIds, string $openId, string $brand, bool $fromSubscribe, string $createdAtStart, string $createdAtEnd) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getChannelLogs(["page" => $page, "pageSize" => $pageSize, "channelId" => $channelId, "channelIds" => $channelIds, "openId" => $openId, "brand" => $brand, "fromSubscribe" => $fromSubscribe, "createdAtStart" => $createdAtStart, "createdAtEnd" => $createdAtEnd]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}