<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2023-05-05 10:27:02
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Auth
 */
class Auth {
    private static string $serviceName = "UserAuth";

    private static string $className = "Auth";

    /**
     * 通过用户名&amp;密码登录
     * @return  mixed
    */
    public static function loginByPass (string $phone, string $pass, string $temp_token = '', string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPass(["phone" => $phone, "pass" => $pass, "temp_token" => $temp_token, "brand" => $brand]);
    }
    /**
     * 通过用户名&amp;密码登录 校验token
     * @return  mixed
    */
    public static function loginByPwd (string $phone, string $pass, string $token, string $tokenType, string $tempToken = '', string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByPwd(["phone" => $phone, "pass" => $pass, "token" => $token, "tokenType" => $tokenType, "tempToken" => $tempToken, "brand" => $brand]);
    }
    /**
     * 微信公众号登录-手机验证码
     * @return  mixed
    */
    public static function wxLoginByPhone (string $brand, string $phone, string $caption, string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wxLoginByPhone(["brand" => $brand, "phone" => $phone, "caption" => $caption, "temp_token" => $temp_token]);
    }
    /**
     * 通过临时token换取token
     * @return  string
    */
    public static function getTokenByTemp (string $brand, string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTokenByTemp(["brand" => $brand, "temp_token" => $temp_token]);
    }
    /**
     * 通过小程序code换取temp_token
     * @return  string
    */
    public static function getTempTokenByCode (string $brand, string $code) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTempTokenByCode(["brand" => $brand, "code" => $code]);
    }
    /**
     * 通过token登陆
     * @return  mixed
    */
    public static function loginByToken (string $token, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByToken(["token" => $token, "brand" => $brand]);
    }
    /**
     * 根据token获取openid
     * @return  string
    */
    public static function getOpenIdByToken (string $token, string $brand = null) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOpenIdByToken(["token" => $token, "brand" => $brand]);
    }
    /**
     * 绑定第三方OAuth用户标示
     * @return  mixed
    */
    public static function bindOAuthId (int $type, string $openId, string $brand, string $headImg) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindOAuthId(["type" => $type, "openId" => $openId, "brand" => $brand, "headImg" => $headImg]);
    }
    /**
     * 退出登录
     * @return  mixed
    */
    public static function logout (string $token, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->logout(["token" => $token, "brand" => $brand]);
    }
    /**
     * 根据登录ID获取权限(此接口用于网关获取登录状态)
     * @return  array
    */
    public static function getAuthInfoById (string $auth_id) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthInfoById(["auth_id" => $auth_id]);
    }
    /**
     * 获取当前session过期时间
     * @return  mixed
    */
    public static function getAuthExpireTime () {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthExpireTime();
    }
    /**
     * 获取当前用户权限
     * @return  mixed
    */
    public static function getUserPermission (string $prefix = '') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserPermission(["prefix" => $prefix]);
    }
    /**
     * 微信小程序登录-使用加密数据
     * @return  mixed
    */
    public static function wxAppLoginByEncrypted (string $brand, string $mobile_encrypt, string $mobile_iv, string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->wxAppLoginByEncrypted(["brand" => $brand, "mobile_encrypt" => $mobile_encrypt, "mobile_iv" => $mobile_iv, "temp_token" => $temp_token]);
    }
    /**
     * 根据code绑定品牌用户
     * @return  bool
    */
    public static function bindUserWechatByCode (string $code, string $brand, int $userId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserWechatByCode(["code" => $code, "brand" => $brand, "userId" => $userId]);
    }
    /**
     * 根据code绑定品牌用户微信信息
     * @return  bool
    */
    public static function bindUserWxInfoByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindUserWxInfoByCode(["code" => $code, "brand" => $brand]);
    }
    /**
     * 微信三方登录-海马体app
     * @return  mixed
    */
    public static function loginByOpenId (string $phone, string $brand = 'mantu_app', string $openId, string $caption, string $accessToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByOpenId(["phone" => $phone, "brand" => $brand, "openId" => $openId, "caption" => $caption, "accessToken" => $accessToken]);
    }
    /**
     * 苹果账户三方登录
     * @return  mixed
    */
    public static function loginByAppleToken (string $phone, string $caption, string $identityToken, string $brand = 'mantu_app') {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByAppleToken(["phone" => $phone, "caption" => $caption, "identityToken" => $identityToken, "brand" => $brand]);
    }
    /**
     * app端获取token
     * @return  mixed
    */
    public static function getTokenFromApp (string $brand = 'mantu_app', string $deviceToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getTokenFromApp(["brand" => $brand, "deviceToken" => $deviceToken]);
    }
    /**
     * 通过userId获取友盟设备号
     * @return  mixed
    */
    public static function getUserDeviceByUserId (int $userId, string $brand = 'mantu_app') {
        return RpcClass::getClass(self::$serviceName, self::$className)->getUserDeviceByUserId(["userId" => $userId, "brand" => $brand]);
    }
    /**
     * 通过小程序code获取openID
     * @return  string
    */
    public static function getOpenIdByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getOpenIdByCode(["code" => $code, "brand" => $brand]);
    }
    /**
     * 通过小程序code获取openID和unionID
     * @return  mixed
    */
    public static function code2SessionByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->code2SessionByCode(["code" => $code, "brand" => $brand]);
    }
    /**
     * 支付宝小程序登录-使用加密数据
     * @return  mixed
    */
    public static function alipayMiniLoginByEncrypted (string $brand, string $decryptData, string $tempToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->alipayMiniLoginByEncrypted(["brand" => $brand, "decryptData" => $decryptData, "tempToken" => $tempToken]);
    }
    /**
     * 通过支付宝小程序code登录
     * @return  mixed
    */
    public static function loginByCodeByAlipayMini (string $code, string $brand, string $phone, string $tempToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->loginByCodeByAlipayMini(["code" => $code, "brand" => $brand, "phone" => $phone, "tempToken" => $tempToken]);
    }
    /**
     * 通过支付宝小程序code获取userId
     * @return  array
    */
    public static function getAlipayUserIdByCode (string $code, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAlipayUserIdByCode(["code" => $code, "brand" => $brand]);
    }
    /**
     * 发送短信并校验鉴权temp-token
     * @return  mixed
    */
    public static function sendSmsWithTempToken (string $brand, string $phone, string $tempToken) {
        return RpcClass::getClass(self::$serviceName, self::$className)->sendSmsWithTempToken(["brand" => $brand, "phone" => $phone, "tempToken" => $tempToken]);
    }
    /**
     * 绑定微信
     * @return  array
    */
    public static function bindWechat (string $tempToken, string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->bindWechat(["tempToken" => $tempToken, "brand" => $brand]);
    }
    /**
     * 移除用户绑定信息
     * @return  bool
    */
    public static function removeUserAuthBindInfo (string $brand, int $userId, string $openId) {
        return RpcClass::getClass(self::$serviceName, self::$className)->removeUserAuthBindInfo(["brand" => $brand, "userId" => $userId, "openId" => $openId]);
    }
    /**
     * 用户当前绑定信息
     * @return  array
    */
    public static function userAuthBindInfo (string $brand) {
        return RpcClass::getClass(self::$serviceName, self::$className)->userAuthBindInfo(["brand" => $brand]);
    }
    /**
     * java验证loginEvent
     * @return  bool
    */
    public static function checkLoginEvent (int $userId, string $brand, string $tempToken, string $deviceToken, string $secret) {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkLoginEvent(["userId" => $userId, "brand" => $brand, "tempToken" => $tempToken, "deviceToken" => $deviceToken, "secret" => $secret]);
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}