<?php
/**
 * auto gen by rpc-tool: 1.2.6; datetime: 2022-12-26 15:03:57
 */
namespace Mainto\Bridge\Invokes\UserAuth;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class WechatOAuth
 */
class WechatOAuth {
    private static string $serviceName = "UserAuth";

    private static string $className = "WechatOAuth";

    /**
     * 获取微信认证跳转Url
     *
     */
    public static function getAuthUrl (string $brand, string $scopes, string $url) {
        return RpcClass::getClass(self::$serviceName, self::$className)->getAuthUrl(["brand" => $brand, "scopes" => $scopes, "url" => $url, ]);
    }
    /**
     * 通过Code获取微信用户信息
     *
     */
    public static function authByCode (string $code, string $state) {
        return RpcClass::getClass(self::$serviceName, self::$className)->authByCode(["code" => $code, "state" => $state, ]);
    }
    /**
     * 登录后获取用户数据
     *
     */
    public static function afterAuthGetUserInfo (string $temp_token) {
        return RpcClass::getClass(self::$serviceName, self::$className)->afterAuthGetUserInfo(["temp_token" => $temp_token, ]);
    }
    /**
     * 创建会员卡
     *
     */
    public static function createMemberCard (array $cardInfo, string $scene): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->createMemberCard(["cardInfo" => $cardInfo, "scene" => $scene, ]);
    }
    /**
     * 更新会员卡积分
     *
     */
    public static function updateMemberInfo (string $scene, string $cardId, string $cardCode, string $note, int $integral): bool {
        return RpcClass::getClass(self::$serviceName, self::$className)->updateMemberInfo(["scene" => $scene, "cardId" => $cardId, "cardCode" => $cardCode, "note" => $note, "integral" => $integral, ]);
    }
    /**
     * 微信校验回调地址-缦图之家
     *
     */
    public static function checkWxCallbackForMantuHome (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForMantuHome();
    }
    /**
     * 微信校验回调地址-缦图
     *
     */
    public static function checkWxCallbackForMantu (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForMantu();
    }
    /**
     * 微信校验回调地址-海马体
     *
     */
    public static function checkWxCallbackForHimo (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForHimo();
    }
    /**
     * 微信校验回调地址-kids
     *
     */
    public static function checkWxCallbackForKids (): string {
        return RpcClass::getClass(self::$serviceName, self::$className)->checkWxCallbackForKids();
    }

    /**
     * registerMock
     * @throws    \Exception
     * @return    RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass(self::$serviceName, self::$className);
    }


    /**
     * @deprecated
     * @var
     */
    private static $instance;

    /**
     * @deprecated
     * 获取一个远程调用类
     * @return    static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * getClass
     * @deprecated
     * @throws    \Exception
     * @return    self
     */
    public static function getClass () {
        return RpcClass::getClass(self::$serviceName, self::$className);
    }

    /**
     * @deprecated
     * @param    $name
     * @param    $arguments
     * @return    mixed
     * @throws    \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}