<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByTokenByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Login\LoginByTokenCmd $params)
 */
class Login {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 根据token登录
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Login\LoginByTokenCmd $loginByTokenCmd
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByToken (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\Login\LoginByTokenCmd $loginByTokenCmd) {
        return self::getClass()->loginByToken($loginByTokenCmd);
    }


    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\Login');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\Login');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}