<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method getAuthListByParams(array|\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AuthBase\AuthListCmd $params)
 * @method getAuthInfoByParams(array $params)
 * @method getUserDeviceListByParams(array $params)
 * @method getUserDeviceInfoByParams(array $params)
 */
class AuthBase {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 获取登录鉴权信息-批量
     *
     * @var  \Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AuthBase\AuthListCmd $authListCmd
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\AuthListDTO
     */
    public static function getAuthList (\Mainto\Bridge\Structs\UserAuth\Rpc\Cmd\AuthBase\AuthListCmd $authListCmd) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAuthList($authListCmd),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\AuthListDTO"
        );
    }


    /**
     * 获取用户鉴权信息
     *
     * @param  string $brand 品牌 [ require true ]
     * @param  int $userId 用户id [ require false ]
     * @param  string $thirdIdentityId 第三方证牌 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\AuthDetailDTO
     */
    public static function getAuthInfo (string $brand, int $userId = 0, string $thirdIdentityId = '') {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getAuthInfo([
                            "brand" => $brand,
                            "userId" => $userId,
                            "thirdIdentityId" => $thirdIdentityId,
                        ]),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\AuthDetailDTO"
        );
    }

    /**
     * 获取app登录设备关联信息-list
     *
     * @param  array $brands 平台s [ require false ]
     * @param  array $userIds 用户IDs [ require false ]
     * @param  array $deviceTokens 友盟tokens [ require false ]
     * @param  int $page 分页 [ require false ]
     * @param  int $pageSize 每页条数 [ require false ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\UserDeviceListDTO
     */
    public static function getUserDeviceList (array $brands = [], array $userIds = [], array $deviceTokens = [], int $page = 1, int $pageSize = 200) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserDeviceList([
                            "brands" => $brands,
                            "userIds" => $userIds,
                            "deviceTokens" => $deviceTokens,
                            "page" => $page,
                            "pageSize" => $pageSize,
                        ]),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\UserDeviceListDTO"
        );
    }

    /**
     * 获取用户关联device信息
     *
     * @param  string $brand 平台 [ require true ]
     * @param  int $userId 用户ID [ require true ]
     * @throws  \Exception
     * @return  \Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\UserDeviceDetailDTO
     */
    public static function getUserDeviceInfo (string $brand, int $userId) {
        return app('json_mapper')->mapUseTypeString(
            self::getClass()->getUserDeviceInfo([
                            "brand" => $brand,
                            "userId" => $userId,
                        ]),
            "\Mainto\Bridge\Structs\UserAuth\Rpc\DTO\AuthBase\UserDeviceDetailDTO"
        );
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\AuthBase');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\AuthBase');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}