<?php
namespace Mainto\Bridge\Invokes\UserAuth\Rpc;

use Mainto\RpcServer\RpcClient\RpcClass;
use Mainto\RpcServer\RpcClient\RpcMockClass;
use Mainto\RpcServer\RpcServer\RpcDefinition;
use InvalidArgumentException;

/**
 * Class Unique
 * @method loginByPassByParams(array $params)
 * @method wxLoginByPhoneByParams(array $params)
 * @method getTempTokenByCodeByParams(array $params)
 * @method loginByTokenByParams(array $params)
 */
class Auth {
    private static $instance;

    /**
     * 获取一个远程调用类
     * @return  static
     */
    public static function getDirectClass () {
        if (self::$instance == null) {
            self::$instance = new self();
        }

        return self::$instance;
    }

    /**
     * 通过用户名&amp;密码登录-DDD版本
     *
     * @param  string $phone 用户手机号 [ require true ]
     * @param  string $pass 密码 [ require true ]
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $tempToken 临时token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByPass (string $phone, string $pass, string $brand, string $tempToken = '') {
        return self::getClass()->loginByPass([
            "phone" => $phone,
            "pass" => $pass,
            "brand" => $brand,
            "tempToken" => $tempToken,
        ]);
    }

    /**
     * 微信公众号登录-手机验证码-DDD版本
     *
     * @param  string $brand 项目源 [ require true ]
     * @param  string $phone 手机号 [ require true ]
     * @param  string $caption 手机验证码 [ require true ]
     * @param  string $tempToken temp_token [ require false ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function wxLoginByPhone (string $brand, string $phone, string $caption, string $tempToken = '') {
        return self::getClass()->wxLoginByPhone([
            "brand" => $brand,
            "phone" => $phone,
            "caption" => $caption,
            "tempToken" => $tempToken,
        ]);
    }

    /**
     * 通过小程序code换取temp_token-DDD版本
     *
     * @param  string $brand 品牌ID [ require true ]
     * @param  string $code 小程序code [ require true ]
     * @throws  \Exception
     * @return  string
     */
    public static function getTempTokenByCode (string $brand, string $code) {
        return self::getClass()->getTempTokenByCode([
            "brand" => $brand,
            "code" => $code,
        ]);
    }

    /**
     * 通过token登陆
     *
     * @param  string $token 系统颁发token [ require true ]
     * @param  string $brand 品牌ID [ require true ]
     * @throws  \Exception
     * @return  mixed
     */
    public static function loginByToken (string $token, string $brand) {
        return self::getClass()->loginByToken([
            "token" => $token,
            "brand" => $brand,
        ]);
    }

    /**
     * getClass
     * @deprecated
     * @throws  \Exception
     * @return  mixed
     */
    public static function getClass () {
        return RpcClass::getClass('UserAuth', 'Rpc\Auth');
    }

    /**
     * registerMock
     * @throws  \Exception
     * @return  RpcMockClass
     */
    public static function registerMock () {
        return RpcClass::registerMockClass('UserAuth', 'Rpc\Auth');
    }

    /**
     * @param  $name
     * @param  $arguments
     * @return  mixed
     * @throws  \Exception
     */
    public function __call ($name, $arguments) {
        if (substr($name, -8, 8) === 'ByParams') {
            $shortName = str_replace('ByParams', '', $name);
            return self::getClass()->$shortName(...$arguments);
        }

        throw new InvalidArgumentException('Method not found! : '.$name);
    }
}